/**
 * @author pritam.patil
 * withdraw from program Request Details Panel 
 */
Ext.define('Academia.view.servicerequest.withdrawfromcourseprogramservice.WithdrawFromProgramDetailsPanel', {
    extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.withdrawfromprogramdetailspanel',
    frame: false,
    border: false,
    plugins: "formlabelrequired",
    cls: 'x-form-fixed-footer-parent',
    items: [{
        xtype: 'hidden',
        name: 'id'
    },{
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'nestedJsonCombo',
        name: 'assignee',
        itemId: 'assigneeId',
        hidden: true,
        width: 256
    }, {
        xtype: 'nestedJsonCombo',
        name: 'serviceRequestSetting',
        itemId: 'settingId',
        hidden: true,
        width: 256
    }, {
        xtype: 'requesterdetailspanel',
        itemId: 'requesterDetails',
        margin: 0
    }, {
        xtype: 'basicdetails',
        itemId: 'programBasicDetails',
        style: {
            marginBottom: '-29px',
            marginLeft: '0px'
        }
    }, {
        xtype: 'fieldcontainer',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        style: {
            marginLeft: '10px',
            marginBottom: '20px'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('FROM_PROGRAM'),
            name: 'fromProgramId',
            store: 'servicerequest.programcoursesectiontransfer.FromPrograms',
            valueField: 'id',
            itemId: 'fromProgramId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local'
        },{
            xtype: 'textfield',
            fieldLabel: getServiceRequestTranslation('PROGRAM_ENROLLED_FOR'),            
            name: 'program',
            itemId: 'withdrawFromProgram',
            allowBlank: false,
            readOnly:true,
            width: 256
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'vbox'
        },
        width: 700,
        style: {
             marginLeft: '10px'
        },
        items: [{
        	  xtype: 'displayfield',
        	  width: 700,
        	  labelWidth:700,
        	  cls:'hideDisplayText',
        	  labelSeparator:' ',
              fieldLabel: getCommonTranslation('PW_AUTHORIZED_DECLARATION'),
              itemId: 'authorizeDeclarationDetails',
              name: 'authorizeDeclarationDetails'
    	    },{
    	    	xtype: 'checkboxfield',
    			width: '100%',
    			cls:'acceptCheckBox',
    			labelAlign: 'right',
    			boxLabel: getCommonTranslation('PW_AUTHORIZED_CHECKBOX'),
    			name: 'authorizeDeclaration',
    			itemId:'authorizeDeclarationId',
    			inputValue : true,
    			afterBoxLabelTpl:'',
    			uncheckedValue: false 
    	    },{
        	xtype: 'checkboxfield',
    		width: '100%',
    		cls:'hideCheckBox',
    		labelAlign: 'right',
    		boxLabel: getCommonTranslation('IMPORTANT_NOTE'),
    		name: 'studentdeclaration',
    		itemId:'studentDeclarationId',
    		inputValue : true,
    		afterBoxLabelTpl:':',
    		uncheckedValue: false 
        },{
        	  xtype: 'displayfield',
        	  width: 700,
        	  labelWidth:700,
        	  cls:'hideDisplayText',
        	  labelSeparator:' ',
              itemId: 'studentDeclarationDetails',
              fieldLabel: getCommonTranslation('IMPORTANT_NOTE_CONTENT'),
              name: 'studentDeclarationDetails'
        }, {
        	xtype: 'checkboxfield',
        	width: '100%',
    		labelAlign: 'right',
    		boxLabel: getCommonTranslation('STUDENT_DECLARATION'),
    		name: 'studentApply',
    		cls:'hideCheckBox',
    		itemId:'studentApplyId',
    		inputValue : true,
    		afterBoxLabelTpl:':',
    		uncheckedValue: false 
        },{
      	  xtype: 'displayfield',
      	  width: 700,
      	  labelWidth:700,
      	  labelSeparator:' ',
      	  cls:'hideDisplayText',
          itemId: 'forStudentsApplyingDetails',
          fieldLabel: getCommonTranslation('STUDENT_DECLARATION_CONTENT_WITHDRAW'),
          name: 'forStudentsApplyingDetails'
    },{ 
    	xtye:'checkboxgroup',
    	itemId:'isConfirmation',
    	width: '100%',
    	allowBlank: false,
    	style: {
    		marginLeft: '0px'
    	},
    	items:[{
        	xtype: 'checkboxfield',
        	width: '100%',
    		labelAlign: 'right',
    		cls:'acceptCheckBox',
    		boxLabel:getCommonTranslation('ACCEPT_STUDENT_DECLARATION'),
    		name: 'confirmation',
    		itemId:'confirmationId',
    		inputValue : true,
    		afterBoxLabelTpl:'.',
    		uncheckedValue: false 
    	}]
    }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        cls: 'form-fixed-footer',
        style: {
            //marginLeft: '7px',
            marginTop : '-28px'
        },
        items: [{
            xtype: 'button',
            text: getServiceRequestTranslation('UPLOAD_DOC'),
            itemId: 'programWithdrawSubmitBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
            ui: 'CustomBtnSubmit',
            itemId: 'withdrawButtonId',
            scale: CONSTANTS.BUTTONSIZE,
            hidden: true
        }]


    }]
});