/**
 *  @author Deepak S
 */
Ext.define('Academia.view.setup.campaignmaster.MapSchoolPriorityGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.mapschoolprioritygrid',
	store : 'setup.campaignmaster.MapSchoolPriorityStore',
	id:'mapschoolprioritygridId',
	border: true,
	refreshStoreData:true,
	deferEmptyText: false,
	//emptyText: getCommonTranslation('NORESULTSNMESSAGE'),
	title: getCommonTranslation("MAP_SCHOOL_PRIORITY"),
	//height:1000,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'mapschoolprioritytabstructure':1
		}
	},
	selType :'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : true
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			itemId:'managePaggingToolBarItemId',
			plugins:['pagesize'],
			store : 'setup.campaignmaster.MapSchoolPriorityStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
			xtype: 'button',
			text : getCommonTranslation('SET_DEFAULT_PRIORITY'),
			itemId: 'setDefaultPriorityBtn',
			//ui : 'CustomBtnSubmit',
			disabled:true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text : getCommonTranslation('SAVE'),
			itemId: 'mapSchoolSubmitBtn',
			//ui : 'CustomBtnSubmit',
			disabled:true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('COPY_MAPPING'),
			itemId: 'copyMappingBtn',
			//ui : 'CustomBtnSubmit',
			disabled:true,
			scale: CONSTANTS.BUTTONSIZE
		//}]
	},{
		xtype: 'customcombobox',
		name: 'school',
		itemId: 'schoolId',
		fieldLabel: getCommonTranslation("SCHOOL"),
		valueField: 'id',
		displayField: 'value',
		store: Ext.create('Academia.store.campaignnew.CampaignSchoolStore'),
		queryParam:'schoolName',
		minChars:3,
		width : 296,
		labelWidth:50,
		typeAhead:false,
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		hideTrigger:false,
		forceSelection:true,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		triggerAction: '',
		maxLength:100,
		style:{
			'margin-left':'10px !important',
			'margin-right':'5px !important'
		},
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
					picker.width = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			}
		}
	},{
		xtype : 'button',
		text : getCommonTranslation('RESET'),
		//ui : 'CustomBtnCancel',
		name : 'resetBtnGrid',
		itemId : 'resetBtnGrid',
		disabled:true,
		scale : CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		itemId: 'exportReportItemId',
		text: getCommonTranslation('EXPORTREPORTS'),
		disabled:true
	}],
	columns: [{
		header:  getCommonTranslation('SCHOOL_CODE'),
		dataIndex: 'campaignSchoolCode',
		flex:1,
		hidden:true,
		sortable:true
	},{
		header:  getCommonTranslation('SCHOOL'),
		dataIndex: 'campaignSchoolName',
		flex:1,
		sortable:true
	}, {
		header : getCommonTranslation('DOMESTIC_PRIORITY_P1'),
		dataIndex:'DOMESTIC_PRIORITY_P1', 
		stopSelection: false, 
		flex : 1,
		renderer: function(value, meta, record) {
			var indx = record.index;
			var recVal = record.data.schoolPriority;
			var dataIndx = meta.column.dataIndex;
			var val =false;
			if(recVal == dataIndx){
				val = true;
			}
			return '<center><input type="radio" style="width:14px;height:14px;" name="radio'+indx+'"' + (val ? 'checked="true"' : '');
		}
	}, {
		header : getCommonTranslation('DOMESTIC_PRIORITY_P2'),
		dataIndex:'DOMESTIC_PRIORITY_P2', 
		stopSelection: false, 
		flex : 1,
		renderer: function(value, meta, record) {
			var indx = record.index;
			var recVal = record.data.schoolPriority;
			var dataIndx = meta.column.dataIndex;
			var val =false;
			if(recVal == dataIndx){
				val = true;
			}
			return '<center><input type="radio" style="width:14px;height:14px;" name="radio'+indx+'"' + (val ? 'checked="true"' : '');
		}
	}, {
		header : getCommonTranslation('DOMESTIC_PRIORITY_P3'),
		dataIndex:'DOMESTIC_PRIORITY_P3', 
		stopSelection: false, 
		flex : 1,
		renderer: function(value, meta, record) {
			var indx = record.index;
			var recVal = record.data.schoolPriority;
			var dataIndx = meta.column.dataIndex;
			var val =false;
			if(recVal == dataIndx){
				val = true;
			}
			return '<center><input type="radio" style="width:14px;height:14px;" name="radio'+indx+'"' + (val ? 'checked="true"' : '');
		}
	}, {
		header : getCommonTranslation('DOMESTIC_PRIORITY_P4'),
		dataIndex:'DOMESTIC_PRIORITY_P4', 
		stopSelection: false, 
		flex : 1,
		renderer: function(value, meta, record) {
			var indx = record.index;
			var recVal = record.data.schoolPriority;
			var dataIndx = meta.column.dataIndex;
			var val =false;
			if(recVal == dataIndx){
				val = true;
			}
			return '<center><input type="radio" style="width:14px;height:14px;" name="radio'+indx+'"' + (val ? 'checked="true"' : '');
		}
	}, {
		header : getCommonTranslation('INTERNATIONAL_PRIORITY_I1'),
		dataIndex:'INTERNATIONAL_PRIORITY_I1', 
		stopSelection: false, 
		flex : 1,
		renderer: function(value, meta, record) {
			var indx = record.index;
			var recVal = record.data.schoolPriority;
			var dataIndx = meta.column.dataIndex;
			var val =false;
			if(recVal == dataIndx){
				val = true;
			}
			return '<center><input type="radio" style="width:14px;height:14px;" name="radio'+indx+'"' + (val ? 'checked="true"' : '');
		}
	}, {
		header : getCommonTranslation('INTERNATIONAL_PRIORITY_I2'),
		dataIndex:'INTERNATIONAL_PRIORITY_I2', 
		stopSelection: false, 
		flex : 1,
		renderer: function(value, meta, record) {
			var indx = record.index;
			var recVal = record.data.schoolPriority;
			var dataIndx = meta.column.dataIndex;
			var val =false;
			if(recVal == dataIndx){
				val = true;
			}
			return '<center><input type="radio" style="width:14px;height:14px;" name="radio'+indx+'"' + (val ? 'checked="true"' : '');
		}
	}, {
		header : getCommonTranslation('SCHOOL_NOT_PRIORITIZED'),
		dataIndex:'SCHOOL_NOT_PRIORITIZED', 
		stopSelection: false, 
		flex : 1,
		renderer: function(value, meta, record) {
			var indx = record.index;
			var recVal = record.data.schoolPriority;
			var dataIndx = meta.column.dataIndex;
			var val =false;
			if(recVal == dataIndx){
				val = true;
			}
			return '<center><input type="radio" style="width:14px;height:14px;" name="radio'+indx+'"' + (val ? 'checked="true"' : '');
		}
	}]
});
