/**
 * @author priyanshi sharma
 */
var portalData = Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [
        {"id":1, "value":"Core ERP"},
        {"id":2, "value":"Employee"},
        {"id":3,"value":"Student"},
        {"id":6, "value":"Applicant"},
        {"id":7, "value":"Parent"},
        {"id":8, "value":"Student Mobile App"},
        {"id":9, "value":"Parent Mobile App"}] 

});
Ext.define('Academia.view.setup.controlPanel.ControlPanelPrivilegeGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.controlpanelprivilegegrid',	
	store:'setup.controlPanel.ControlPanelPrivilegeGridStore',
	columns:[{
		header:'Portal',
		flex:0.1,
		dataIndex:'portal',
		renderer:function(value) {
			return value.value;
		}	
	},{
		header:'Module',
		flex:0.1,
		dataIndex:'module',
		renderer:function(value) {
			return value.value;
		}	
	},{
		header:'Sub - Module',
		dataIndex:'subModule',
		flex:0.1,
		renderer:function(value) {
			return value.value;
		}	
	},{
		header:'Feature',
		dataIndex:'feature',
		flex:0.1,
		renderer:function(value) {
			return value.value;
		}
	},{
		xtype:'checkcolumn',
		header:'visibility',
		align: 'left',
		flex:0.1,
		dataIndex : 'granted'			
	},],
	tbar: [{
		xtype: 'customcombobox',
		store: 'reports.userroleprivilege.URPPortalStore',
		displayField: 'portalName',
		valueField: 'id',
		editable: false,
		itemId: 'portalCombo',
		//value:0,
		//queryMode: 'local',
		emptyText: 'Select Portal', listeners: {
			render: function(combo) {
				var store = Ext.create('Academia.store.reports.userroleprivilege.URPPortalStore');
				combo.bindStore(store);
			}
		},
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					var combo = picker.up('combobox');
					picker.setWidth(combo.getWidth());
				}
			}
		}
	},{
		xtype:'customcombobox',
		store:'securitysetup.ModuleStore',
		displayField:'moduleName',
		valueField:'id',
		editable:false,
		queryMode: 'local',
		itemId:'moduleCombo',
		emptyText:'Select Module',
		listeners: {
			render: function(combo) {
				var store = Ext.create('Academia.store.securitysetup.ModuleStore');
				combo.bindStore(store);
			}
		},
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					var combo = picker.up('combobox');
					picker.setWidth(combo.getWidth());
				}
			}
		}
	},{
		xtype:'customcombobox',
		store:'securitysetup.SubModuleStore',
		displayField:'moduleName',
		queryMode: 'local',
		valueField:'moduleName',
		editable:false,
		disabled:true,
		itemId:'subModuleCombo',
		emptyText:'Select Sub Module',
		listeners: {
			render: function(combo) {
				var store = Ext.create('Academia.store.securitysetup.SubModuleStore');
				combo.bindStore(store);
			}
		},
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					var combo = picker.up('combobox');
					picker.setWidth(combo.getWidth());
				}
			}
		}
	},{
		xtype:'button',
		text:getCommonTranslation('SEARCH'),
		itemId:'btnSearchRolePrivilege',
		disabled:true
	},{
		xtype:'button',
		text:getCommonTranslation('SAVE'),
		action:'save',
		itemId:'btnSavePrivilege'
	},{
		xtype:'button',
		text:getCommonTranslation('RESET'),
		itemId:'btnResetPrivilege'
	},{
		xtype:'button',
		text:getCommonTranslation('Visibility all'),
		itemId:'btnGrantAllPrivilege'
	},{
		xtype:'button',
		text:getCommonTranslation('REVOKE_ALL'),
		itemId:'btnRevokeAllPrivilege',
		disabled:true
	}]	
});