/**
 * @author Amit Gupta
 * this form is used for Terms and condition search 
 */
Ext.define('Academia.view.setup.dashboard.TermsandConditionViewSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.termsandconditionviewsearchform',
    frame: false,
    cls:'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'multiselectcombofield',
            fieldLabel: getCommonTranslation('TERMCONDITION_ACADEMY_LOCATION'),
            name: 'ACADEMY_LOCATION_ID',
            itemId: 'academyLocationId',
            store:'common.AcademyLocationNameSeparated',
            displayField: 'value',
            valueField: 'id',
            width: 536,
            allowBlank:false,
            queryMode: 'remote',
            typeAhead : false,
            forceSelection:true,
           // triggerAction: 'all',
            minChars:3,
            queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
        }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            name: 'fromDate',
            fieldLabel: getCommonTranslation('TERMCONDITION_FROM_DATE'),
            itemId: 'from_date',
            msgTarget: 'qtip',
            vtype: 'daterange',
            endDateField: 'till_date',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
        }, {
            xtype: 'datefield',
            name: 'tillDate',
            fieldLabel: getCommonTranslation('TERMCONDITION_TILL_DATE'),
            itemId: 'till_date',
            msgTarget: 'qtip',
            vtype: 'daterange',
            startDateField: 'from_date',
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
        }]
     },{
         xtype: 'fieldcontainer',
         width: '100%',
         layout: {
             type: 'hbox'
         },
         defaults: {
             width: 256,
             labelAlign: 'top'
         },
         items: [{
            xtype: 'customcombobox',
             fieldLabel: getCommonTranslation('TERMCONDITION_USER_TYPE'),
             store:'setup.dashboard.UserGroupTermandConditionReportStore',
             name: 'userType',
             itemId: 'userType',
             valueField: 'id',
             displayField:'userGroupName',
             allowBlank:false,
             editable: false
         }]
      },{
        xtype: 'fieldcontainer',
        width: '100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            ui: 'CustomBtnSubmit',
            formBind : true,
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'clearSearch',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});