/**
 * @author Raghavendra.Soni
 * this is used to add template form  
 */
Ext.define('Academia.view.setup.loginPageContent.LoginPageConfigurationForm', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.loginpageconfigurationform',
    width: '98%',
    height: '100%',
    defaults: {
        bodyStyle: 'padding:15px',
        collapsed: true,
        header:{
        	titleAlign: 'center',
        	titlePosition: 1
        }
    },
    layout: {
        type: 'accordion',
        titleCollapse: false,
        animate: true,
        activeOnTop: false,
        multi: true
    },
    items: [{
        title: 'Home Page',
        border: true,
        frame: true,
        xtype: 'panel',
        items:[{
            xtype: 'ckeditor',
            itemId: 'templateCKEditor_homePage',		        
            autoHeight: true,
            submitValue: false,
            width: '100%',
            height: 400,
            maxLength: 9999999,
            name: 'templateCKEditor_homePage'
        },{
            xtype: 'button',
            itemId: 'submitHomePageButtonId',
            pageCode: 'homePage',
            text: getCommonTranslation('SUBMIT'), //Submit
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            cls: 'no-icon-btn'
        }]
    },{
        title: 'Student Portal',
        border: true,
        frame: true,
        xtype: 'panel',
        items:[{
            xtype: 'ckeditor',
            itemId: 'templateCKEditor_studentPortal',		        
            autoHeight: true,
            submitValue: false,
            width: '100%',
            height: 400,
            maxLength: 9999999,
            name: 'templateCKEditor_studentPortal'
        },{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			height: 40,
			defaults: {
				width: 256
			},
			items:[{
	        	xtype: 'checkboxfield',
	            itemId: 'isCaptchaVisible_studentPortal',
	            labelAlign: 'right',
	            boxLabel: getCommonTranslation('IS_CAPTCHA_REQUIRED'),
	            name: 'isCaptchaVisible_studentPortal',
	            inputValue: true,
	            uncheckedValue: false,
	            style: {
	                marginTop: '10px'
	            }
	        },{
	        	xtype: 'checkboxfield',
	            itemId: 'termsConditions_studentPortal',
	            labelAlign: 'right',
	            boxLabel: getCommonTranslation('LOGIN_TERMS_AND_CONDITIONS'),
	            name: 'termsConditions_studentPortal',
	            inputValue: true,
	            uncheckedValue: false,
	            style: {
	                marginTop: '10px'
	            }
	        }]
        },{
            xtype: 'button',
            itemId: 'submitStudentPortalButtonId',
            pageCode: 'studentPortal',
            text: getCommonTranslation('SUBMIT'), //Submit
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            cls: 'no-icon-btn'
        }]
    },{
        title: 'Parent Portal',
        border: true,
        frame: true,
        xtype: 'panel',
        items:[{
            xtype: 'ckeditor',
            itemId: 'templateCKEditor_parentPortal',		        
            autoHeight: true,
            submitValue: false,
            width: '100%',
            height: 400,
            maxLength: 9999999,
            name: 'templateCKEditor_parentPortal'
        },{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			height: 40,
			defaults: {
				width: 256
			},
			items:[{
	        	xtype: 'checkboxfield',
	            itemId: 'isCaptchaVisible_parentPortal',
	            labelAlign: 'right',
	            boxLabel: getCommonTranslation('IS_CAPTCHA_REQUIRED'),
	            name: 'isCaptchaVisible_parentPortal',
	            inputValue: true,
	            uncheckedValue: false,
	            style: {
	                marginTop: '10px'
	            }
	        },{
	        	xtype: 'checkboxfield',
	            itemId: 'termsConditions_parentPortal',
	            labelAlign: 'right',
	            boxLabel: getCommonTranslation('LOGIN_TERMS_AND_CONDITIONS'),
	            name: 'termsConditions_parentPortal',
	            inputValue: true,
	            uncheckedValue: false,
	            style: {
	                marginTop: '10px'
	            }
	        }]
        },{
            xtype: 'button',
            itemId: 'submitParentPortalButtonId',
            pageCode: 'parentPortal',
            text: getCommonTranslation('SUBMIT'), //Submit
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            cls: 'no-icon-btn'
        }]
    },{
        title: 'Applicant Portal',
        border: true,
        frame: true,
        xtype: 'panel',
        items:[{
            xtype: 'ckeditor',
            itemId: 'templateCKEditor_applicantPortal',		        
            autoHeight: true,
            submitValue: false,
            width: '100%',
            height: 400,
            maxLength: 9999999,
            name: 'templateCKEditor_applicantPortal'
        },{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			height: 40,
			defaults: {
				width: 256
			},
			items:[{
	        	xtype: 'checkboxfield',
	            itemId: 'isCaptchaVisible_applicantPortal',
	            labelAlign: 'right',
	            boxLabel: getCommonTranslation('IS_CAPTCHA_REQUIRED'),
	            name: 'isCaptchaVisible_applicantPortal',
	            inputValue: true,
	            uncheckedValue: false,
	            style: {
	                marginTop: '10px'
	            }
	        },{
	        	xtype: 'checkboxfield',
	            itemId: 'termsConditions_applicantPortal',
	            labelAlign: 'right',
	            boxLabel: getCommonTranslation('LOGIN_TERMS_AND_CONDITIONS'),
	            name: 'termsConditions_applicantPortal',
	            inputValue: true,
	            uncheckedValue: false,
	            style: {
	                marginTop: '10px'
	            }
	        }]
        },{
            xtype: 'button',
            itemId: 'submitApplicantPortalButtonId',
            pageCode: 'applicantPortal',
            text: getCommonTranslation('SUBMIT'), //Submit
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            cls: 'no-icon-btn'
        }]
    },{
        title: 'Admin Portal',
        border: true,
        frame: true,
        xtype: 'panel',
        items:[{
            xtype: 'ckeditor',
            itemId: 'templateCKEditor_adminPortal',		        
            autoHeight: true,
            submitValue: false,
            width: '100%',
            height: 400,
            maxLength: 9999999,
            name: 'templateCKEditor_adminPortal'
        },{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			height: 40,
			defaults: {
				width: 256
			},
			items:[{
	        	xtype: 'checkboxfield',
	            itemId: 'isCaptchaVisible_adminPortal',
	            labelAlign: 'right',
	            boxLabel: getCommonTranslation('IS_CAPTCHA_REQUIRED'),
	            name: 'isCaptchaVisible_adminPortal',
	            inputValue: true,
	            uncheckedValue: false,
	            style: {
	                marginTop: '10px'
	            }
	        },{
	        	xtype: 'checkboxfield',
	            itemId: 'termsConditions_adminPortal',
	            labelAlign: 'right',
	            boxLabel: getCommonTranslation('LOGIN_TERMS_AND_CONDITIONS'),
	            name: 'termsConditions_adminPortal',
	            inputValue: true,
	            uncheckedValue: false,
	            style: {
	                marginTop: '10px'
	            }
	        }]
        },{
            xtype: 'button',
            itemId: 'submitAdminPortalButtonId',
            pageCode: 'adminPortal',
            text: getCommonTranslation('SUBMIT'), //Submit
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            cls: 'no-icon-btn'
        }]
    },{
        title: 'Teacher/Faculty	 Portal',
        border: true,
        frame: true,
        xtype: 'panel',
        items:[{
            xtype: 'ckeditor',
            itemId: 'templateCKEditor_teacherPortal',		        
            autoHeight: true,
            submitValue: false,
            width: '100%',
            height: 400,
            maxLength: 9999999,
            name: 'templateCKEditor_teacherPortal'
        },{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			height: 40,
			defaults: {
				width: 256
			},
			items:[{
	        	xtype: 'checkboxfield',
	            itemId: 'isCaptchaVisible_teacherPortal',
	            labelAlign: 'right',
	            boxLabel: getCommonTranslation('IS_CAPTCHA_REQUIRED'),
	            name: 'isCaptchaVisible_teacherPortal',
	            inputValue: true,
	            uncheckedValue: false,
	            style: {
	                marginTop: '10px'
	            }
	        },{
	        	xtype: 'checkboxfield',
	            itemId: 'termsConditions_teacherPortal',
	            labelAlign: 'right',
	            boxLabel: getCommonTranslation('LOGIN_TERMS_AND_CONDITIONS'),
	            name: 'termsConditions_teacherPortal',
	            inputValue: true,
	            uncheckedValue: false,
	            style: {
	                marginTop: '10px'
	            }
	        }]
        },{
            xtype: 'button',
            itemId: 'submitTeacherPortalButtonId',
            pageCode: 'teacherPortal',
            text: getCommonTranslation('SUBMIT'), //Submit
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            cls: 'no-icon-btn'
        }]
    },{
        title: 'Alumni Portal',
        border: true,
        frame: true,
        xtype: 'panel',
        items:[{
            xtype: 'ckeditor',
            itemId: 'templateCKEditor_alumniPortal',		        
            autoHeight: true,
            submitValue: false,
            width: '100%',
            height: 400,
            maxLength: 9999999,
            name: 'templateCKEditor_alumniPortal'
        },{
        	xtype: 'checkboxfield',
            itemId: 'isCaptchaVisible_alumniPortal',
            labelAlign: 'right',
            boxLabel: getCommonTranslation('IS_CAPTCHA_REQUIRED'),
            name: 'isCaptchaVisible_alumniPortal',
            inputValue: true,
            uncheckedValue: false,
            style: {
                marginTop: '10px'
            }
        },{
            xtype: 'button',
            itemId: 'submitAlumniPortalButtonId',
            pageCode: 'alumniPortal',
            text: getCommonTranslation('SUBMIT'), //Submit
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            cls: 'no-icon-btn'
        }]
    }]
});

