/**
 *  @author priyanshi sharma
 */
Ext.define('Academia.view.setup.sessionlogouttimesetup.SessionLogoutTimeStudentPortalSetupView', {
	extend : 'Ext.form.Panel',
	alias : 'widget.sessionlogouttimestudentportalsetupview',
	title: getCommonTranslation('STUDENT_PORTAL_SETUP'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		 stripeRows : CONSTANTS.STRIPEROWS
	},
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			itemId : 'lblSessionTimeout',
        	html: getCommonTranslation('SESSION_TIMEOUT'),
        	style : {
    			'margin-Left' : '32px !important'
    		}
        },{
			xtype: 'customcombobox',
			name:'noOfHours',
			itemId:'noOfHours',
			fieldLabel: getCommonTranslation('HOURS'),
			width: 125,
			store: Ext.create('Academia.store.setup.sessionlogouttimesetup.SessionLogoutTimeSetupHourStore'),
			value:'0',
			displayField: 'value',
			forceSelection: true,
			editable: false,
			style : {
				marginLeft : '-50px',
			},
		},{
			xtype: 'customcombobox',
			name:'noOfMinutes',
			itemId:'noOfMinutes',
			fieldLabel: getCommonTranslation('MINUTES'),
			width: 125,
			store:Ext.create('Academia.store.setup.sessionlogouttimesetup.SessionLogoutTimeSetupMinuteStore'),
			value:'15',
			displayField: 'value',
			forceSelection: true,
			editable: false,
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			itemId : 'lblMinMaxTime',
        	html: '<span class="required" style="color:grey">'+'Minimum: 1 minute Maximum: 4 hours'+'</span>',
        	style : {
    			marginLeft : '238px !important;'
    		}
        },]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		items: [{
			xtype: 'container',
			flex: 1
		}, {
			xtype: 'button',
			text: getCommonTranslation('SAVE'),
			itemId: 'sessionLogoutSave',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'sessionLogoutReset',
			ui: 'CustomBtnCancel',
			cls:'CustomBtnSubmitToolbaar',
			scale: CONSTANTS.BUTTONSIZE,
			style : {
				marginLeft : '30px'
			},
			handler: function() {
	               this.up('form').getForm().reset();
	           }
		}]	
	}]
});