
Ext.require([
    'Ext.ux.form.MultiSelect'
]);
Ext.define('Academia.view.setup.templatemapping.AddTemplateMapping',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.addtemplatemapping',
	title : getCommonTranslation('ADD_TEMPLATE_MAPPING'),
	autoScroll: true,
	frame:true,
    method: 'POST',
//    
	style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    cls:'x-form-fixed-footer-parent',
	plugins : "formlabelrequired",
	items : [{
		xtype : 'hidden',
		name : 'id'
	},{
		xtype:'hidden',
		name:'templateCode'
	},{
		xtype:'hidden',
		name:'headerImagePrimary1'
	},{
		xtype:'hidden',
		name:'headerImageSecondary1'
	},{
		xtype:'hidden',
		name:'footerImageFileDetail1'
	},{
		xtype:'hidden',
		name:'watermarkImageFileDetail1'
	},{
		xtype:'hidden',
		name:'version'
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('TEMPLATE_TYPE'),
			itemId: 'templateType',
			name: 'templateType', 
			store:'setup.templatemapping.TemplateType',
			valueField:'id',
			displayField:'value',
			allowBlank:false						
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
			itemId: 'templateName',
			name: 'templateName', 
			store:'setup.templatemapping.TemplateName',
			valueField:'id',
			displayField:'value',
			queryParam:'reportTemplateName',
			minChars:3,
			allowBlank:false,	
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			},
			disabled:true
		},{
			xtype : 'button',
			text : 'Preview Template',
			itemId : 'previewTemplateBtn',
			ui : 'CustomBtnThird',
			scale : CONSTANTS.BUTTONSIZE,
			disabled:true,
			style:{
				marginTop:'30px'
			}
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [
		         {
		        	xtype : 'multiselectcombofield',
		 			name : 'academyLocation',
					itemId:'academyLocationId',
					autoloadStore: false,
					width: 536,
					fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
					store:'common.AcademyLocationNameSeparated',
					valueField : 'id',
					displayField : 'value',
					allowBlank : false,
					queryParam:'qry',
					minChars:3,
					typeAhead:true,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}' +
							'</div>';
						}
					}
		         }]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'checkboxfield',
			width: 'auto',
			labelAlign: 'right',
			boxLabel: getCommonTranslation('REPEAT_HEADER'),
			name: 'repeatHeader',
			inputValue : true,
			uncheckedValue: false

		},{
			xtype: 'checkboxfield',
			width: 'auto',
			labelAlign: 'right',
			itemId:'downlable_Id',
			boxLabel: getCommonTranslation('REPEAT_FOOTER'),
			name: 'repeatFooter',
			inputValue : true,
			uncheckedValue: false

		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
//			width : '223',
			labelAlign : 'top'
		},
		items : [{
			xtype:'fieldcontainer',
			layout:'vbox',
			width:'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype:'image',
				itemId: 'Primary_image',
				hidden:true,
				border: 1,
				style: {
					borderColor: 'black',
					borderStyle: 'solid'
				},
				width: 130,
				height: 150
			},{
				xtype: 'filefield',
				fieldLabel: 'Primary',
				buttonText: getPersonModuleTranslation('UPLOAD'),
				itemId: 'primaryPhotoUploadForm',
				ui: 'CustomBtnSubmit',
				name: 'headerImagePrimary',
			/*	listeners:{
					change: function(field, val) { 
		                var fileName = /^.*\.(exe)$/i;
		                if(fileName.test(val)){
		                	field.reset();
		                	showWarningMessage(getCommonTranslation('UPLOAD_DOCUMENT'),getCommonTranslation('CANNOT_UPLOAD_EXE_FILE'));
		                	return false;
		                }
		          }
				}*/
			}]},{
				xtype:'fieldcontainer',
				layout:'vbox',
				width:'auto',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items:[{
					xtype:'image',
					itemId: 'secondary_image',
					hidden:true,
					border: 1,
					style: {
						borderColor: 'black',
						borderStyle: 'solid'
					},
					width: 130,
					height: 150
				},{
					xtype: 'filefield',
					fieldLabel: 'Secondary',
					buttonText: getPersonModuleTranslation('UPLOAD'),
					itemId: 'secondaryPhotoUploadForm',
					ui: 'CustomBtnSubmit',
					name: 'headerImageSecondary'
				}]
			}]},{
				xtype : 'fieldcontainer',
				width : '100%',
				layout : {
					type : 'hbox'
				},
				defaults : {
//					width : '223',
					labelAlign : 'top'
				},
				items : [{
					xtype:'fieldcontainer',
					layout:'vbox',
					width:'auto',
					defaults: {
						width: 256,
						labelAlign: 'top'
					},
					items:[{
						xtype:'image',
						itemId: 'footer_image',
						hidden:true,
						border: 1,
						style: {
							borderColor: 'black',
							borderStyle: 'solid'
						},
						width: 130,
						height: 150
					},{
						xtype: 'filefield',
						fieldLabel: 'Footer',
						buttonText: getPersonModuleTranslation('UPLOAD'),
						itemId: 'footerPhotoUploadForm',
						ui: 'CustomBtnSubmit',
						name: 'footerImageFileDetail'
					}]},{
						xtype:'fieldcontainer',
						layout:'vbox',
						width:'auto',
						defaults: {
							width: 256,
							labelAlign: 'top'
						},
						items:[{
							xtype:'image',
							itemId: 'waterMark_image',
							hidden:true,
							border: 1,
							style: {
								borderColor: 'black',
								borderStyle: 'solid'
							},
							width: 130,
							height: 150
						},{
							xtype: 'filefield',
							fieldLabel: 'Water Mark',
							buttonText: getPersonModuleTranslation('UPLOAD'),
							itemId: 'waterMarkPhotoUploadForm',
							ui: 'CustomBtnSubmit',
							name: 'watermarkImageFileDetail'
						}]}
					]},{
		xtype:'fieldcontainer',
		width:'auto',
		layout : {
			type : 'hbox'
		},
		//width:500,
		cls:'form-fixed-footer',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'saveBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			text : getCommonTranslation('CANCEL'),
			itemId : 'cancelBtn',
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		}]
	} 
	]
		    	
});