/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.view.sgappointment.sgappointment.SGAppointmentForm',{
//	extend:'Academia.view.common.DynamicFieldForm',
//	extend:'Academia.view.common.IdGeneratorForm',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	formCode:'appointmentForm',
	alias : 'widget.sgappointmentform',
	overflowY: 'auto',
	//bodyPadding:'10 10 10 10',
	frame:true,
	listeners:{
		beforeRender: function(){
			Ext.apply(this,{ 
				customFieldEntity:CONSTANTS.SG_APPOINTMENT,
			    columns: 1
		    });
	   	}
	},
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	cls:'horizontalScrollingFixed x-form-fixed-footer-parent', 
	method: 'POST',
	defaults: {
		labelAlign: 'top',
		width: 256
	},
	plugins : "formlabelrequired",
	items : [{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'hidden',
			name: 'submitPortalId',
			itemId:'submitPortalId'
		},{

			xtype: 'customcombobox',
			name: 'visitorCategory',
			itemId:'visitorCategoryID',
			fieldLabel: getServiceRequestTranslation('SG_VISITOR_CATEGORY'),
			store:'sgappointment.sgappointment.SGVisitorCategoryStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			allowBlank: false,
			editable: false,
		}, 
		{
			xtype:'textfield',
			name: 'bookingId',
			itemId:'bookingId',
			//allowBlank: false,
            emptyText: getCommonTranslation('ID_AUTOGENERATE'),
			fieldLabel: getServiceRequestTranslation('BOOKING_ID') 
		},{
			xtype : 'customcombobox',
			name : 'academyLocation',
			itemId:'academyLocationId',
			fieldLabel : getEnquiryTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.common.AcademyLocationAppointment'),
			valueField : 'id',
			displayField : 'value',
			allowBlank : true,
			hidden : true,
			editable: false
		},{
			xtype: 'customcombobox',
			name: 'program',
			itemId:'programId',
			fieldLabel: getEnquiryTranslation('PROGRAM'),
			allowBlank: true,
			store:Ext.create('Academia.store.program.ProgramsForAppointment'),
			displayField:'valueCode',
			valueField:'id',
			forceSelection:true,
			hidden : true,
			disabled : true,
			editable: false
		},{
			xtype: 'customcombobox',
			name: 'batch',
			itemId:'batchId',
			fieldLabel: getEnquiryTranslation('BATCH'),
			allowBlank: true,
			store:Ext.create('Academia.store.enquiry.BatchesForAppointment'),
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection:true,
			hidden : true,
			disabled : true
		},{
			xtype: 'customcombobox',
			name: 'seatType',
			itemId : 'seatTypeId',
			fieldLabel: getEnquiryTranslation('SEAT_TYPE'),
			allowBlank: true,
			store:Ext.create('Academia.store.enquiry.ProgramBatchSeatTypeForAppointment'),
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection:true,
			hidden : true,
			disabled : true
		}]
	},
	{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype:'textfield',
			name: 'appointeeName',
			fieldLabel: getServiceRequestTranslation('APPOINTEE_NAME'),
			itemId:'appointeeNameId',
			maxLength:255,
			allowBlank: false
		},{
			xtype : 'customcombobox',
			name: 'appointeeNameParent',
			fieldLabel: getServiceRequestTranslation('PARENT_STUDENT_NAME'),
			itemId:'appointeeNameParentId',
			allowBlank: false,
			hidden:true,
			store:'sgappointment.sgappointment.SGParentGuardianStore',
			valueField: 'id',
			displayField: 'value',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:false,
			hideTrigger:true,
			forceSelection:true,
			//maxLength: 40,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype : 'customcombobox',
			name: 'leadId',
			fieldLabel: getEnquiryTranslation('ENQUIRY_ID_OR_STUDENT_NAME'),//getEnquiryTranslation('ENQUIRY_ID'),
			itemId:'leadId',
			allowBlank: false,
			hidden:true,
			store:'enquiry.EnquiryCodeSearchForAppointmentStore',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:false,
			hideTrigger:true,
			forceSelection:true,
			//maxLength: 40,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'studentId',
			itemId:'studentItemId',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: 'feeandpayment.managebill.Student',
			allowBlank: false,
			hidden:true,
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getPersonModuleTranslation('EMPLOYEE_ID_OR_NAME'),
			name: 'facAppointmentId',
			itemId:'facAppointmentId',
			store:'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:false,
			allowBlank: false,
			hideTrigger:true,
			forceSelection:true,
			hidden:true,
			//allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'applicantNameId',
			itemId:'applicantNameId',
			store:'admission.applications.applicantProfileBase.ApplicantSmartSearchStore',
			fieldLabel:getAdmissionTranslation('APPLICANT_ID_NAME'),
			width: 256,
			valueField: 'id',
			displayField: 'printName',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:false,
			hideTrigger:true,
			hidden:true,
			allowBlank: false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{printName}'  +
					'</div>';
				}
			}
		},{
			xtype: 'fieldcontainer',
			itemId:'appointmentCellFieldContainerId',
			fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
			layout : {
				type : 'hbox'
			},
			items : [ {
				xtype : 'hidden',
				name : 'id',
				itemId : 'id',
			},{
				xtype : 'customcombobox',
				name : 'mobileCountryCode',
				itemId : 'cellCountryCode',
				valueField : 'isdCode',
				displayField : 'isdCode',
				store:Ext.create('Academia.store.common.CountryStore'),
				triggerAction : 'all',
				editable : false,
				forceSelection:true ,
				width: 80,
				emptyText: 'Code',
			    minChars: 1
			}, {
				xtype : 'numberfield',
				name : 'appointeeContactNo',
				itemId:'mobileNo',
				minLength: 0,
				maxLength: 15,
				enforceMaxLength : true,
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				allowExponential:false,
				width : 145,
				emptyText: 'Mobile Number',
			}]
		}, 
		{
			xtype: 'textfield',
			name: 'appointeeEmailId',
			itemId: 'appointeeEmailItemId',
			fieldLabel : getServiceRequestTranslation('EMAIL_ID'),
			vtype:'email',
			//allowBlank:false,
			maxLength:40,
			enforceMaxLength : true

		}]
	},{

		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items:[ {

			xtype: 'customcombobox',
			name: 'reasonForVisitID',
			itemId:'reasonForVisitID',
			fieldLabel: getServiceRequestTranslation('REASON_FOR_MEET'),
			store:'sgappointment.sgappointment.SGReasonForVisitStore',
			displayField:'code',
			valueField:'id',
			forceSelection:true,
			//allowBlank: false,
			editable: false,
			
		},{
			xtype : 'textfield',
			itemId: 'additionalReasonToVisitItemId',
			fieldLabel : getCommonTranslation('ADDITIONAL_VISIT_REASON'),
			name : 'additionalReasonToVisit',
			disabled:true,
			allowBlank: false,
			
           },{
			xtype:'datefield',
			name: 'appointmentDate',
			fieldLabel: getServiceRequestTranslation('SG_APPOINTMENT_DATE'),
			itemId:'appointmentId',
			allowBlank: false,
			//vtype: 'daterange',
			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			/*,*/
			//startDateField: 'bookingDateId',
			//minValue:new Date(),
			//value:new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}

		},{
			xtype: 'radiogroup',
			//style:{marginLeft:'-2px !important'},
			itemId:'isAppointeeItemId',
			labelAlign: 'top',
			fieldLabel:getCommonTranslation('DO_YOU_WANT_TO_NOTIFY_APPOINTEE'),
			columns: 2,
			vertical: true,
			items: [
			        { boxLabel: getAdmissionTranslation('YES'), name: 'isAppointee', inputValue: true,checked:true},
			        { boxLabel: getAdmissionTranslation('NO'), name: 'isAppointee', inputValue: false,}
			        ]
		},{
			xtype: 'customcombobox',
			fieldLabel: getServiceRequestTranslation('PERSON_TO_MEET'),
			name: 'personToMeet',
			itemId:'personToMeetId',
			store:'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			allowBlank:false,
			enableKeyEvents  : 'true',
			maxLength: 150,
			triggerAction: '',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'button',
			itemId: 'viewCalendar',
			name:'viewCalendarName',
			style:"margin-top:28px;",
			ui : 'CustomBtnThird',
			text: getServiceRequestTranslation('VIEW_CALENDAR'),
			cls: 'sg-appointment-view-calendar-button-cls no-icon-btn'
		}/*,{

			xtype: 'customcombobox',
			name: 'viewStatusID',
			itemId:'viewStatusID',
			fieldLabel: getServiceRequestTranslation('SG_VISIT_STATUS'),
			store:'sgappointment.sgappointment.SGVisitStatus',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			//allowBlank: false,
			editable: false,
		}*/]
	},{

        xtype : 'fieldcontainer',
        width : '100%',
        layout : {
            type : 'hbox'
        },
        defaults : {
            width: 256,
            labelAlign : 'top'
        },
        itemId:'flagRadioFld',
    //    height:60,
        items:[
            {
                xtype: 'radiogroup',
                //style:{marginLeft:'-2px !important'},
                itemId:'flagRelatedRadio',
                labelAlign: 'top',
                fieldLabel:getCommonTranslation('IS_THIS_RELATED_TO_FLAG'),
                columns: 2,
                height:60,
                vertical: true,
                items: [
                        { boxLabel: getAdmissionTranslation('YES'), name: 'isRelatedToFlag', inputValue: true},
                        { boxLabel: getAdmissionTranslation('NO'), name: 'isRelatedToFlag', inputValue: false,checked:true}
                        ]
            },
            {
            
            xtype: 'customcombobox',
            name: 'flagUserId',
            itemId:'flagUserId',
            fieldLabel: getCommonTranslation('FLAG_ID_NAME'),
            store:'sgappointment.sgappointment.SGAppointmentFlagIdStore',
            displayField:'value',
            valueField:'id',
            disabled:true,
            allowBlank: false,
            editable: false,
            hidden:true
            
        }]
        },{

		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items:[{
			xtype : 'timefield',
			name: 'visitTime',
			itemId:'visitTimeId',	
			fieldLabel :getServiceRequestTranslation('VISIT_TIME'),
			//format: CONSTANTS.DISPLAY_TIME_FORMAT,
			//submitFormat:CONSTANTS.SUBMIT_TIME_FORMAT,
			//value:new Date(),
			vtype: 'timerange',
			submitFormat : 'g:i A',
			endTimeField : 'outTimeId',
			//allowBlank:false,
			listeners: {
				render: function(field) {
					return timeFormatRender(field);
				}
			},
			editable: false,
		},{ 
			xtype:'timefield',
			name: 'expectedOutTime',
			itemId:'outTimeId',
			//format: CONSTANTS.DISPLAY_TIME_FORMAT,
			//submitFormat:CONSTANTS.SUBMIT_TIME_FORMAT,
			submitFormat : 'g:i A',
			fieldLabel: getServiceRequestTranslation('EXPECTED_OUT_TIME'),
			vtype: 'timerange',
			startTimeField :'visitTimeId',
			listeners: {
				render: function(field) {
					return timeFormatRender(field);
				}
			},
			editable: false,
			
		}]
		},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items:[{

			xtype: 'customcombobox',
			name: 'viewStatusID',
			itemId:'viewStatusID',
			fieldLabel: getServiceRequestTranslation('SG_VISIT_STATUS'),
			store:'sgappointment.sgappointment.SGVisitStatus',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			//allowBlank: false,
			editable: false,
		},{
			xtype: 'customcombobox',
			name: 'enqIntermediateStage',
			itemId: 'enqIntermediateStage',
			store: 'enquiry.EnqIntermediateType',
			fieldLabel: getEnquiryTranslation('INTERMEDIATE_STAGE'),
			valueField: 'id',
			displayField: 'value',
			allowBlank: true,
			typeAhead: true,
			forceSelection: true
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items:[{
			xtype : 'textareafield',
			itemId: 'reasonToVisitItemId',
			fieldLabel : getServiceRequestTranslation('REMARK'),
			name : 'reasonToVisit',
//			vtype: 'NospaceAsInput',
			maxLength: 250,
			//allowBlank:false,
			width: 700,
			listener:{
				blur:function(){}
			}

		}]
	},{

		xtype : 'fieldcontainer',
		width : '100%',
		hidden:true,
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype:'datefield',
			name: 'bookingDate',
			fieldLabel: getServiceRequestTranslation('BOOKING_DATE'),
			itemId:'bookingDateId',
			allowBlank: false,
			//value:new Date(),
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype: 'daterange',
			//endDateField: 'appointmentId',
			readOnly:true,
			editable: true,
			listeners: {
				render: function(field) {
					field = dateFormatRender(field);						
					field.setValue(new Date());
				}
			},
		}]

	},/*{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items:[]

	},
	 {
		xtype : 'displayfield',
		name : 'displayEntryExit',
		value : '<b class="menu-title">'
			+ getServiceRequestTranslation('BOOKING_SLOT')
			+ '</b>',
			style : {
				textDecoration : "underline"
			}
	},*/{

		xtype : 'fieldcontainer',
		width : '100%',
		hidden:true,
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items:[{
			xtype: 'customcombobox',
			fieldLabel: getServiceRequestTranslation('ENTRY_BY'),
			name: 'entryBy',
			itemId:'entryById',
			//store:'hostel.roomallocation.UserSmartSearchByUserType',
			store: 'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			minChars:3,
			hidden:true,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			//allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
			maxLength: 150,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype:'textfield',
			name: 'entryByNameItemId',
			fieldLabel: getServiceRequestTranslation('ENTRY_BY'),
			itemId:'entryByNameItemId',
			maxLength:50,
			hidden:true
		}]
	},{

		xtype : 'fieldcontainer',
		width : '100%',
		itemId: 'rescheduleAppointmentFld',
		hidden:true,
		layout : {
			type : 'vbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items:[{
            xtype: 'checkboxfield',
            boxLabel: getCommonTranslation('RESCHEDULE_APPOINTMENT'),
            name: 'isRescheduleAppointment',
            //checked: true,
            inputValue: 'true',
            uncheckedValue: 'false',
            itemId: 'chkRescheduleAppointment'
        },{
			xtype: 'fieldcontainer',
			//fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
			itemId: 'dateTimeRescheduleAppointmentItemId',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype:'datefield',
				name: 'rescheduleDate',
				fieldLabel: getCommonTranslation('RESCHEDULE_APPOINTMENT_DATE'),
				itemId:'rescheduleAppointmentDateId',
				allowBlank: true,
				minValue:new Date(),
				editable: true,
				listeners: {
					render: function(field) {
						field = dateFormatRender(field);						
					}
				}
			}, { 
				xtype:'timefield',
				name: 'rescheduleTime',
				itemId:'rescheduleAppointmentTimeId',
				submitFormat : 'g:i A',
				fieldLabel: getCommonTranslation('RESCHEDULE_APPOINTMENT_TIME'),
				vtype: 'timerange',
				editable: false
			}]
		}]
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		style : 'margin-top:8px;',
		cls: 'form-fixed-footer',
		items : [ {
			xtype : 'button',
			text : getPlacementTranslation('SAVE'),
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},
		 {
			xtype : 'button',
			text : getPlacementTranslation('RESET'),
			ui : 'CustomBtnCancel',
			name : 'resetBtnForm',
			itemId : 'resetBtnForm',
			scale : CONSTANTS.BUTTONSIZE
		},
		]
	},
	{ 

        xtype: 'filefield',
        name : 'documentUploadFile',
        itemId: 'documentUploadFile',
        region: 'south',
        ui: 'CustomBtnSubmit',
        fieldLabel: getCommonTranslation('SELECT_FILE'),
        buttonText: getCommonTranslation('UPLOAD'),
        allowBlank: true,
        name: 'file',
        hidden:true
    
        },
        { 

        	xtype: 'displayfield',
        	name: 'visitorCategory',
        	itemId:'pathId',
        	//fieldLabel: getServiceRequestTranslation('SG_VISITOR_CATEGORY'),
        	//store:'sgappointment.sgappointment.SGVisitorCategoryStore',
        	displayField:'value',
        	valueField:'id',
        	forceSelection:true,
        	allowBlank: false,
        	editable: false,
        	width:'100%'
        }]
}

);
