/**
 * @author Prakash Soni
 * 
 */
Ext.define('Academia.view.sponsorship.SponsorshipDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.sponsorshipdownloadform',
	//plugins : "formlabelrequired",
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype:'fieldcontainer',
		items:[{
			xtype : 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items : [{
				xtype : 'customcombobox',
				name : 'academyLocation',
				itemId:'academyLocation',
				width: 536,
				fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
				store:'common.AcademyLocationNameSeparated',
				valueField : 'id',
				displayField : 'value',
				allowBlank : false,
				forceSelection:true,
				hideTrigger:false,
				typeAhead:true,
				triggerAction: 'all',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				queryParam:'qry'
			}]
		}]},{
			xtype:'fieldcontainer',
			layout : 'hbox',
			items:[{
				xtype: 'fieldcontainer',
				width: '100%',
				defaults: {
					labelAlign: 'top'
				},
				items: [{
						xtype: 'multiselectcombofield',
					    name: 'program',
					    itemId:'program',
					    width: 536,
					    fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
					    store: 'common.ProgramByAcademyLocationStoreWithoutPermission',
					    valueField: 'id',
					    displayField: 'valueCode',
					    allowBlank: true,
					    typeAhead:true,
					    forceSelection:true,
					    hideTrigger:false,
					    typeAhead:true,
					    triggerAction: 'all',
					    minChars:3,
			            queryParam:'programName',
			            cls:'receiptHeaderMultiselect',
			            maxLength:50000,
			            listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{code} / {value}' +
								'</div>';
							}
						}
					},
					{
					xtype: 'multiselectcombofield',
				    name: 'batch',
				    itemId:'batch',
				    fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
				    width: 536,
				    store: 'program.programbatchdetail.BatchStore',
				    valueField: 'id',
				    displayField: 'value',
				    allowBlank: true,
				    typeAhead:true,
				    forceSelection:true,
				    disabled:true,
				    maxLength:50000,
				    cls:'receiptHeaderMultiselect'}]
			  }]
		   },
			{
				xtype: 'fieldcontainer',
				width: '100%',
				defaults: {
					labelAlign: 'top',
				},
				items: [{		

					xtype: 'multiselectcombofield',
					name: 'seatType',
					itemId:'seatType',
					fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
					width: 536,
					store: 'enquiry.ProgramBatchSeatTypeStore',
					valueField: 'id',
					displayField: 'value',			   
					typeAhead:false,
					forceSelection:true,
					autoloadStore: false,
					disabled:true,
				    allowBlank: true,
				    maxLength:50000,
					cls:'receiptHeaderMultiselect',
					
				}]
				},{
					xtype:'fieldcontainer',
					layout : 'hbox',
					cls: 'customSearchPanelBtnsFieldContainerCls',
					items:[{
						xtype: 'button',
						text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
						itemId: 'downoladBtnId',
						ui: 'CustomBtnSubmit',
						formBind:true
					},{
						xtype: 'button',
						text: getCourseTxCommonTranslation('RESET'),
						itemId: 'resetBtn',
						//buttonAlign: 'left',
						ui: 'CustomBtnCancel',
						scale: CONSTANTS.BUTTONSIZE
					}]
				
				}]
});
