/**
 * @author pritam.patil
 * @author Amit G
 * This is used for Sponsorship listing screen search form
 */
Ext.define('Academia.view.sponsorship.SponsorshipListingSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.sponsorshiplistingsearchform',
    frame: false,
    cls:'customSearchPanel',
    //title: getServiceRequestTranslation('QUICK_SEARCH'),
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 696,
            labelAlign: 'top'
        },
        items: [{
			xtype : 'multiselectcombofield',
			name : 'academyLocation',
			itemId:'academyLocationId',
			autoloadStore: false,
			width: 696,
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			valueField: 'id',
		    displayField: 'value',
		    maskRe : /^\S*$/,
			allowBlank : true,
			queryParam:'qry',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
				        });
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			/*	getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}*/
			}
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
        	xtype: 'customcombobox',
			name: 'STUDENT_ID',
			itemId: 'sponList_studId',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: 'feeandpayment.reports.Student',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
        },{

        	xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('SPONSOR_CODE_NAME'), //Sponsor Id
            itemId: 'sponList_sponId', 
            name: 'SPONSOR_ID',
            store:'sponsorship.SponsorsNameCodeStore',
			width: 256,
			valueField: 'id',
			displayField: 'value',
			queryParam:'sponsorNameOrCode',
			minChars:3,
			typeAhead:false,
			//hideTrigger:true,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{sponsorshipCode} / {sponsorshipName}' +
        			'</div>';
        		}
			}
        
        },{
        	xtype: 'customcombobox',
        	fieldLabel: getCommonTranslation('SPONSOR_TYPE'), //Sponsor Type
        	name: 'SPONSOR_TYPE',
        	itemId: 'scholList_scholType',
        	editable: false,
        	//store: 'sponsorship.SponsorTypes',
        	store: 'sponsorship.SponsorTypesStore',
        	displayField: 'value',
        	valueField: 'id',
        	selectOnFocus: true,
        	queryMode : 'local',
        	value : 'All',
        	forceSelection: false
        	//width: 256
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
        	xtype: 'customcombobox',
    		name:'programNameOrCode',
    		store: Ext.create('Academia.store.program.ProgramCodeOrNameSearchByAL'),
    		itemId:'programNameOrCodeId',
    		fieldLabel: getCommonTranslation('PROGRAM'),
    		valueField: 'id',
    		displayField: 'valueCode',
    		queryParam:'qry',
    		minChars:3,
    		allowBlank: true,
    		typeAhead:false,
    		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    		forceSelection:true,
    		listConfig: {
    			listeners: {
    				beforeshow: function(picker) {
    					picker.minWidth = picker.up('combobox').getSize().width;
    				}
    			},
    			loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    				return '<div class="search-item">' +
    				'{code} / {value}'+ 
    				'</div>';
    			}
    		}
        },{
        	xtype: 'customcombobox',
        	name: 'departmentByProgramDepartment',
        	fieldLabel: getCommonTranslation('DEPARTMENT'),
        	itemId:'departmentByProgramDepartmentId',
        	store:Ext.create('Academia.store.department.DepartmentAcademyLocationAndProgramWise'),
        	displayField:'value',
        	valueField:'id',
        	queryParam:'name',
    		minChars:3,
    		allowBlank: true,
    		typeAhead:false,
    		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    		forceSelection:true,
    		listConfig: {
    			listeners: {
    				beforeshow: function(picker) {
    					picker.minWidth = picker.up('combobox').getSize().width;
    				}
    			},
    			loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    		}
        },{
        	xtype: 'customcombobox',
        	name: 'departmentBySubDepartment',
        	itemId:'departmentBySubDepartmentId',
        	fieldLabel: getCommonTranslation('SUB_DEPARTMENT'),
        	store:Ext.create('Academia.store.department.ProgramSubDepartmentByParentDepartment'),
        	displayField:'value',
        	valueField:'id',
        	disabled:true,
        	queryParam:'name',
    		minChars:3,
    		allowBlank: true,
    		typeAhead:false,
    		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    		forceSelection:true,
    		listConfig: {
    			listeners: {
    				beforeshow: function(picker) {
    					picker.minWidth = picker.up('combobox').getSize().width;
    				}
    			},
    			loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    		}
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 400
        },
        items: [{
            xtype: 'label',
            itemId: 'viewSponsorId',
            align: 'bottom',
            html: "<a href = '#'>" + getCommonTranslation('VIEW_PAST_SPONSORSHIP_DATA') + "</a>",
            style: {
                paddingTop: '10px'
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'SponsorshipListSearchBtn',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'sponsorshipListResetButtonId',
            buttonAlign: 'left',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
          /*  listeners: {
                click: function(button, eOpts) {
                    this.up('form').getForm().reset();
                    this.up('form').down('#LOCATION').setDisabled(true);
                }
            }*/
        }]
    }]
});