/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show contact person details in grid  
 */
Ext.define('Academia.view.sponsorship.SponsorshipMasterSponsorContactPersonDetailsGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.contactpersondetailsgrid',
	store : 'sponsorship.ContactDetails',
	title :getCommonTranslation('LIST_OF_CONTACT_PERSONS'),//List of Contact Persons
	border: true,
	margin:'25 8 8 8',
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'sponsorshipmasterscreen': 1
		}
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns :[{
		header : getCommonTranslation('SPONSOR_Id'),//Sponsor Id
		dataIndex : 'sponsorshipCode',
		flex:.1
	},{
		header : getCommonTranslation('NAME'),//Person Name
		dataIndex : 'contactName',		
		flex:.2
	},{
		header :getCommonTranslation('DESIGNATION'),//Designation
		dataIndex : 'designation',
		flex:.2
	},{
		header :getCommonTranslation('ADDRESS'),//Address
		dataIndex : 'address',
		flex:.2,
		renderer : function(obj){
			return columnObjRender(obj, "addressText");
		}
	},{
		header :getCommonTranslation('ADDRESS_PHONE_NUMBER'),//Phone No.1
		dataIndex : 'address',
		flex:.2,
		renderer : function(obj){
			return columnObjRender(obj, "phoneNo");
		}
	},{
		header :getCommonTranslation('ADDRESS_MOBILE_NO'),//Phone No.2
		dataIndex : 'address',
		flex:.2,
		renderer : function(obj){
			return columnObjRender(obj, "cellNo");
		}
	},{
		header :getCommonTranslation('ADDRESS_PRIMARY_EMAIL'),//Email Id 1
		dataIndex : 'address',
		flex:.2,
		renderer : function(obj){
			return columnObjRender(obj, "primaryeEmailId");
		}
	},{
		header :getCommonTranslation('ADDRESS_SECONDARY_EMAIL'),//Email Id 2
		dataIndex : 'address',
		flex:.2,
		renderer : function(obj){
			return columnObjRender(obj, "alternateEmailId");
		}
	}, {
		header : getCommonTranslation('BENEFICIARY_NAME'),
		dataIndex : 'beneficiaryName',		
		flex:.2
	}, {
		header : getCommonTranslation('ACCOUNT_NO'),
		dataIndex : 'accountNo',		
		flex:.2
	}, {
		header : getCommonTranslation('ACCOUNT_TYPE'),
		dataIndex : 'accountTypeId',		
		flex:.2,
		renderer: function(value){
			return columnObjRender(value,"value");
		}
	}, {
		header : getCommonTranslation('BANK_NAME'),
		dataIndex : 'bankNameId',		
		flex:.2,
		renderer: function(value){
			return columnObjRender(value,"value");
		}
	}, {
		header : getCommonTranslation('BRANCH_NAME'),
		dataIndex : 'branchName',		
		flex:.2,
		renderer: function(branchName){
			return columnObjRender(branchName,"branchName");
		}
	}, {
		header : getCommonTranslation('IFSC_CODE'),
		dataIndex : 'ifscCodeId',		
		flex:.2,
		renderer: function(code){
			return columnObjRender(code,"code");
		}
	}],
	tbar : [{
		xtype : 'button',				
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
		//text : getCommonTranslation('ADD')
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
		//text : getCommonTranslation('EDIT')
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
			//text : getCommonTranslation('VIEW')
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
		//text : getCommonTranslation('DELETE')
	}],	
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'sponsorship.ContactDetails',
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo: true
		}]
	}],
	showContactPersonDetailsForm: function() {				
		var winAddressDetailsForm=Ext.widget('contactpersondetailswindow');
		winAddressDetailsForm.show();					
	}
});