/**
 * @author priyanshi sharma
 * 
 * 
 */
Ext.define('Academia.view.sponsorship.invoice.SponsorInvoiceCaptureWin', {
    extend: 'Academia.view.personinfo.common.PersonCommonWindow',
    alias: 'widget.sponsorinvoicecapturewin',
    title: getCommonTranslation('INVOICE_CAPTURE'),
    maxHeight : 450,
    width: 610,
    resizable: false,
    items: [{
    	xtype: 'idgeneratorformwin',
    	formCode:'sponsorInvoiceForm',
    	plugins : "formlabelrequired",
    	itemId: 'addSponsorInvoiceform',
    	items:[{
    		xtype: 'hidden',
    		name: 'id',
    		itemId : 'hidden_id'
    	},{
    		xtype: 'fieldcontainer',
    		layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
    		items: [{
				xtype: 'radiogroup',
				itemId: 'bill_receivable_payable',
				name: 'bill_receivable_payable',
				fieldLabel: getFeeAndPaymentCommonTranslation('BILL_RECEIVABLE_PAYABLE'),
				columns: 2,
				vertical: false,
				layout: {
					type: 'hbox'
				},
				items: [{
					boxLabel: getCommonTranslation('BILL_RECEIVABLE'),
					name: 'bill_receivable_payable',
					itemId: 'bill_receivable_payable_Invoice',
					inputValue: 'BILL_RECEIVABLE',
					checked: true
				}, {
					boxLabel: getCommonTranslation('BILL_PAYABLE'),
					name: 'bill_receivable_payable',
					itemId: 'bill_receivable_payable_CreditNote',
					inputValue: 'BILL_PAYABLE' 
				}]
			},{
    			xtype: 'customcombobox',
    			fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
    			itemId: 'academyLocationId', 
    			name: 'academyLocation',
    			store:'common.AcademyLocationNameSeparated',
    			valueField : 'id',
    			displayField : 'value',
    			queryParam:'qry',
    			minChars:3,
    			typeAhead:false,
    			allowBlank: false,
    			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerAction: '',
    			forceSelection:true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						//picker.minWidth = picker.up('combobox').getSize().width;
    						var combo = picker.up('combobox');
    						picker.setWidth(combo.getWidth());
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
    		}]
    	},{
    		xtype: 'fieldcontainer',
    		layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
    		items: [{
    			xtype : 'textfield',
    			name : 'sponsorInvoiceCode',		
    			fieldLabel : getFeeAndPaymentCommonTranslation('INVOICE_NUMBER'),  
    			//enforceMaxLength:true,
    			emptyText: getCommonTranslation('ID_AUTOGENERATE'),
    			//maxLength:10,
    			itemId : 'sponsorInvoiceId',
    			//maskRe:/^[a-z0-9]+$/i
    		},{
    			xtype: 'datefield',
    			fieldLabel:getCommonTranslation('INVOICE_DATE'),
    			name: 'invoiceDate',
    			itemId:'invoiceDate',
    			vtype: 'daterange',
    			editable:false,
    			allowBlank: false,
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			}
    		}]
    	},{
    		xtype: 'fieldcontainer',
    		layout:'hbox',
    		width: 'auto',
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items: [{
    			xtype: 'customcombobox',
    			fieldLabel: getCommonTranslation('SPONSOR_CODE_NAME'),
    			itemId: 'sponsorIdName', 
    			name: 'sponsorIdName',
    			store:Ext.create('Academia.store.sponsorship.SponsorsNameCodeStore'),
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'sponsorNameOrCode',
    			minChars:3,
    			typeAhead:false,
    			allowBlank: false,
    			queryCaching: false,
    			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerAction: '',
    			forceSelection:true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						//picker.minWidth = picker.up('combobox').getSize().width;
    						var combo = picker.up('combobox');
    						picker.setWidth(combo.getWidth());
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{sponsorshipCode} / {sponsorshipName}' +
    					'</div>';
    				}
    			}
    		},{
                xtype: 'numberfield',
                name: 'invoiceAmount',
                itemId: 'invoiceAmountId',
                fieldLabel: getCommonTranslation('INVOICE_AMOUNT'),
                allowBlank: false,
                keyNavEnabled: false,
                mouseWheelEnabled: false,
                minValue: 1,
                enforceMaxLength: true,
                maxLength: 14,       
                hidden:true,
                allowExponential: false,
                allowDecimals: true,
                hideTrigger: true,
            }]
    	},{
    		xtype: 'fieldcontainer',
    		layout:'hbox',
    		width: '100%',
    		items: [{
				xtype:'checkbox',
				name:'isInvoiceSentToSponsor',
				itemId:'isInvoiceSentToSponsorId',
				boxLabel:getCommonTranslation('IS_INVOICE_SENT_TO_SPONSOR'),
				labelAlign: 'right',
				inputValue: true,
				width: 400,
			    hidden:true,
            }]
    	},{

            xtype: 'container',
            itemId:'sponsorInvoiceDocContainer',
            hidden:true,
            layout: 'fit',
            items: [{
                xtype: 'sponsorinvoicedocumentgrid',
                itemId: 'sponsorinvoicedocumentgrid',
                width : 250,
                style:{
    				marginLeft:'0px',
    			}
            }]
    	},{
    		xtype: 'fieldcontainer',
    		items: [{
    			xtype: 'button',
    			itemId: 'btnSaveSponsorInvoice',
    			text: getCommonTranslation('SAVE'), 
    			ui: 'CustomBtnSubmit',
    			scale: CONSTANTS.BUTTONSIZE,
    			formBind: true
    		}, {
    			xtype: 'button',
    			itemId: 'btnCancelSponsorInvoice',
    			text: getCommonTranslation('CANCEL'),
    			ui: 'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE
    		},{
			 xtype: 'button',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadSponsorInvoiceItemId',
			 ui: 'CustomBtnThird',
			 hidden:true,
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    	}]
    }]
});