/**
 * @author Priyanshi sharma
 * 
 */
var billCategory = Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [
        {"value":"BILL_RECEIVABLE", "name":getCommonTranslation('BILL_RECEIVABLE')},
        {"value":"BILL_PAYABLE", "name":getCommonTranslation('BILL_PAYABLE')}] 
});
Ext.define('Academia.view.sponsorship.invoice.SponsorInvoiceFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.sponsorinvoicefilter',
	//autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype : 'multiselectcombofield',
			name : 'academyLocation',
			itemId:'academyLocationId',
			fieldLabel : getCommonTranslation('ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			//cls:'multiBrandCampusCls',
			valueField : 'id',
			displayField : 'value',
			allowBlank : false,
			forceSelection:true,
			width: 536,
			typeAhead:true,
			triggerAction: 'all',
			minChars:3,
			queryParam:'qry',
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						//picker.minWidth = picker.up('combobox').getSize().width;
						var combo = picker.up('combobox');
						picker.setWidth(combo.getWidth());
					}
				}
			}
		},{
			xtype: 'checkboxfield',
	        labelAlign: 'right',
	        width: 256,
	        style:{
	        	marginTop:'25px'
	        },
	        itemId:'whetherInactiveSponsor',
	        boxLabel: getCommonTranslation('INACTIVE_SPONSOR'),
	        name: 'whetherInactiveSponsor',
	        inputValue : true,
	        uncheckedValue: false,
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			 xtype : 'customcombobox',
    		 name : 'billCategory',
    		 itemId:'billCategory',
    		 fieldLabel : getFeeAndPaymentCommonTranslation('BILL_RECEIVABLE_PAYABLE'),
    		 store:billCategory,
    		 valueField : 'value',
    		 displayField : 'name',
    		 value:'BILL_RECEIVABLE',
    		 editable:false
		},{
        	xtype: 'customcombobox',
            fieldLabel: getFeeAndPaymentCommonTranslation('INVOICE_NUMBER'), //Sponsor Id
            itemId: 'sponsorInvoiceNum', 
            name: 'sponsorInvoiceNum',
            store:'sponsorship.invoice.SponsorsInvoiceNumStore',
			width: 256,
			valueField: 'id',
			displayField: 'code',
			queryParam:'sponsorInvoiceNameOrCode',
			minChars:3,
			typeAhead:false,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						//picker.minWidth = picker.up('combobox').getSize().width;
						var combo = picker.up('combobox');
						picker.setWidth(combo.getWidth());
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			}
        },{
    		xtype: 'datefield',
    		fieldLabel:getCommonTranslation('INVOICE_DATE'),
    		name: 'invoiceDate',
    		itemId:'invoiceDate',
    		vtype: 'daterange',
    		hidden:true,
			editable:false,
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		}
        },{
        	xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('SPONSOR_CODE_NAME'),
            itemId: 'sponsorIdName', 
            name: 'sponsorIdName',
            store:Ext.create('Academia.store.sponsorship.SponsorsNameCodeStore'),
			width: 256,
			valueField: 'id',
			displayField: 'value',
			queryParam:'sponsorNameOrCode',
			minChars:3,
			typeAhead:false,
			queryCaching: false,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						//picker.minWidth = picker.up('combobox').getSize().width;
						var combo = picker.up('combobox');
						picker.setWidth(combo.getWidth());
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{sponsorshipCode} / {sponsorshipName}' +
        			'</div>';
        		}
			}
        }]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: '100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'datefield',
			name: 'dateFrom',
			itemId:'dateFrom',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			vtype: 'daterange',
			endDateField: 'dateTill',
			editable:false,
			fieldLabel: getCommonTranslation('FROM_DATE')
		},{
			xtype: 'datefield',
			name: 'dateTill',
			itemId:'dateTill',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.DATE_FORMAT,
			vtype: 'daterange',
			startDateField: 'dateFrom',
			editable:false,
			fieldLabel: getCommonTranslation('TILL_DATE')
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation("SEARCH"),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation("RESET"),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
