/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.sponsorship.invoice.SponsorInvoiceGrid', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.sponsorinvoicegrid',
	store: 'sponsorship.invoice.SponsorInvoiceGridStore',
	title: getCommonTranslation('MANAGE_SPONSOR_INVOICE'),
	border: true,
	frame:false,
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'sponsorinvoicestructure':1
		}
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'sponsorship.invoice.SponsorInvoiceGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'updateAmountReceived',
		text: getCommonTranslation('UPDATE_AMOUNT'),
		tooltip: getCommonTranslation("UPDATE_AMOUNT")
	}],
	columns: [{
		header:  getCommonTranslation('INVOICE_OR_CREDIT_NOTE'),
		dataIndex:'raiseBillCategory',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			if(value=="BILL_RECEIVABLE"){
				return getCommonTranslation('BILL_RECEIVABLE');
			}else if(value=="BILL_PAYABLE"){
				return getCommonTranslation('BILL_PAYABLE');
			}
		}
	},{
		header:  getCommonTranslation('INVOICE_CREDIT_NOTE_NUMBER'),
		dataIndex:'sponsorInvoiceNo',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex:'academyLocation',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			if(!isNullOrEmpty(value)){
				return value.value;
			}
		}
	},{
		header:  getCommonTranslation("INVOICE_DATE"),
		dataIndex: 'invoiceDate',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			return dateRender(value);
		}
	},{
		header:  getCommonTranslation('SPONSOR_Id'),
		dataIndex: 'sponsorCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('SPONSOR_NAME'),
		dataIndex: 'sponsorName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("INVOICE_AMOUNT"),
		dataIndex: 'invoiceAmount',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			if(!isNullOrEmpty(value)){
				if (Ext.isNumber(value)) {
					return Ext.util.Format.number(value, '0.00');
				}
				return value;
			}
		}
	},{
		header:  getFeeAndPaymentCommonTranslation('AMOUNT_RECEIVED'),
		dataIndex: 'totalInvoiceReceivedAmount',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			if(!isNullOrEmpty(value)){
				if(value==0){
					return '';
				}
				if (Ext.isNumber(value)) {
					return Ext.util.Format.number(value, '0.00');
				}
				return value;
			}
		}
	},{
		header:  getFeeAndPaymentCommonTranslation('BALANCE'),
		dataIndex: 'balanceAmount',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			if(!isNullOrEmpty(value) && !isNullOrEmpty(record)){
				if(value==0){
					if(record.data && record.data.totalInvoiceReceivedAmount == record.data.invoiceAmount){
						return '0.00';
					}else{
						return '';
					}
				}
				if (Ext.isNumber(value)) {
					return Ext.util.Format.number(value, '0.00');
				}
				return value;
			}
		}
	},{
		header:  getCommonTranslation("IS_INVOICE_SENT_TO_SPONSOR"),
		dataIndex: 'isInvoiceSent',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			if(value){
			   return "Yes";
			}else{
			   return "No";
			}
		}
	},{
		header:  getCommonTranslation("DOCUMENTS"),
		dataIndex: 'documentCount',
		flex:.1,
		sortable:true,
		renderer:function(value, metadata, record){
			if(value){
				return '<a href="#">'+value+'</a>';
			}else{
				return '';
			}
			
		}
	}]
});
