/**
 * @author akshay.kalbhor
 * This screen will be the base screen which will be shown on Add Sponsorship
 */
Ext.define('Academia.view.sponsorship.sponsorshipListing.AddSponsoredStudent', {
	extend : 'Ext.panel.Panel',
	alias : 'widget.addsponsoredstudent',
	autoScroll: true,
	cls:'horizontalScrollingFixed',
	config: {
		studentId: null
	},
	layout:'vbox',
	defaults:{
		width:'100%'
	},
	// 			
	items : [{
		//xtype:'panel',
    	//items:[{
			xtype: 'fieldcontainer',
			style :{
				'margin-left': '32px',
				'margin-top': '16px'
					},
			defaults: {
                width: 256,
                labelAlign: 'top'
            },
			items: [{
				xtype: 'livesearchcombo',
			    labelAlign: 'top',
			    width: 256,
			    queryParam: 'name',
		    	allowBlank: false,
		    	name: 'studentName',
		    	itemId: 'studentName',
		    	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    	fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
		    	displayField: 'value',
	            valueField: 'id',
	            displayTpl : new Ext.XTemplate(
	             		'<tpl for="."between=" ">',
	             		'{[typeof values === "string" ? values : values["value"]]}'+
	             		'</tpl>'
	             		),
		    	 listeners: {
	                 render: function(combo) {
	                     var store = Ext.create('Academia.store.sponsorship.Students');
	                     combo.bindStore(store);
	                 },
	                 select: function(combo) {
	                 	this.up('panel').setStudentId(combo.getValue());
	                 }
	             }
			}]
	},{
		xype:'panel',
		items:[{
			xtype: 'sponsorfeeheadgrid'
		}]
	}]  	//}]
});