/**
 * @author akshay.kalbhor 
 * This component is used for to show Number Of Sponsored Students for selected sponsorship in grid 
 */
Ext.define('Academia.view.sponsorship.sponsorshipListing.SponsorFeeHeadGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.sponsorfeeheadgrid',	
	store : 'sponsorship.SponsoredStudentsFeeHeads',	
	title : getCommonTranslation('LIST_OF_SPONSORED_FEE_HEADS'), //List of Sponsored students
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS		
	},		  
	border: true,	
	autoScroll:false,
	columns :[
    {
		header : getCommonTranslation('SPONSOR_Id'),//Student Id
		dataIndex : 'sponsorCode',
		sortable : true,
		flex:.2
	},{
		header : getCommonTranslation('SPONSOR_NAME'),//Student Id
		dataIndex : 'sponsorName',
		sortable : true,
		flex:.2
	},{
		header : getCommonTranslation('PROGRAM_NAME'),//Student Name
		dataIndex : 'programName',		
		flex:.2
	},{
		header : getCommonTranslation('FEE_PLAN_NAME'),//Fee Plan
		dataIndex : 'feePlanName',
		hidden:true,
		flex:.2
	},{
		header : getCommonTranslation('FEE_PLAN_ID'),//Fee Plan
		dataIndex : 'feePlanId',		
		flex:.2
	},{
		header : getCommonTranslation('FEE_HEAD_ID'),//Fee Plan
		dataIndex : 'feeHeadName',		
		flex:.2
	},{
		header : getCommonTranslation('FEE_HEAD_AMOUNT'),//Total Amount
		dataIndex : 'totalFeeHeadAmount',		
		flex:.2
	},{
		header : getCommonTranslation('PERCENTAGE_SPONSORED'),//Fee Plan Stages
		dataIndex : 'percentageSponsored',		
		flex:.2
	},{
		header : getCommonTranslation('AMOUNT_SPONSORED'),//Fee Head Type
		dataIndex : 'totalSponsoredAmount',		
		flex:.2
	}] ,
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items :[{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'sponsorship.SponsoredStudentsFeeHeads',
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo: true
		}]
	},{
		xtype : 'toolbar',
		dock : 'top',
		itemId: 'buttonToolbar',
		items: [{
			xtype: 'button',
			itemId: 'btnAdd',
			tooltip: getCommonTranslation('ADD'), //Add
			glyph: ICONGLYPH.ADDGLYPH
		}, {
			xtype: 'button',
			itemId: 'btnEdit',
			tooltip: getCommonTranslation('EDIT'), //Edit
			glyph: ICONGLYPH.EDITGLYPH
		}, {
			xtype: 'button',
			itemId: 'btnView',
			tooltip: getCommonTranslation('VIEW'), //View
			iconCls: 'view-icon'
		}, {
			xtype: 'button',
			itemId: 'btnDelete',
			cls: 'CustomToolbarBtnReject',
			tooltip: getCommonTranslation('DELETE'), //Delete
			glyph: ICONGLYPH.DELETEGLYPH
			/* }, '->', {
             xtype: 'splitbutton',
             text: getCommonTranslation('MOREACTIONS'),
             itemId: 'btnMoreOperations',
             tooltip: getCommonTranslation('MOREACTIONS')*/
		}]
	}]
});