/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.student.bulkUploadDocumentAndNotes.BulkUploadDocAndNotesForm', {
    extend: 'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.bulkUploadDocAndNotesForm',
    border: false,
    frame: false,
    plugins: "formlabelrequired",
    cls: 'customSearchPanel',
    //isRemoveToggleButton:true,
    items: [{
            xtype: 'hidden',
            itemId: 'acadmicTopicHiddenIdBulkUpload',
            name: 'id'
        }, {
            xtype: 'hidden',
            itemId: 'editFlagBulkUpload',
            name: 'isEdit'
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'academicTopicId',
                itemId: 'academicTopicItemIdBulkUpload',
                fieldLabel: getPersonModuleTranslation('ACADEMICS_TOPIC'),
                editable: false,
                allowBlank: false,
                valueField: 'id',
                displayField: 'value',
                queryMode: 'local',
                listeners: {
                    render: function (combo) {
                        var store = Ext.create('Academia.store.student.studentprofile.AcademicTopicUserIdStore');
                        combo.bindStore(store);
                    }
                }
            }, {
                xtype: 'customcombobox',
                name: 'academicSubTopicId',
                itemId: 'academicSubTopicItemIdBulkUpload',
                fieldLabel: getPersonModuleTranslation('ACADEMICS_SUB_TOPIC'),
                editable: false,
                allowBlank: false,
                disabled: true,
                valueField: 'id',
                displayField: 'value',
                queryMode: 'local',
                listeners: {
                    render: function (combo) {
                        var store = Ext.create('Academia.store.student.studentprofile.AcademicSubTopicStore');
                        combo.bindStore(store);
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'programId',
                itemId: 'programItemIdBulkUpload',
                fieldLabel: getPersonModuleTranslation('PROGRAM'),
                allowBlank: false,
                valueField: 'id',
                displayField: 'value',
                store: Ext.create('Academia.store.examCenter.AssignSequence.Program'),
                forceSelection: true
            }, {
                xtype: 'customcombobox',
                name: 'batch',
                itemId: 'batchComboBulkUpload',
                displayField: 'value',
                valueField: 'id',
                //allowBlank: false,
                disabled: true,
                store: Ext.create('Academia.store.examinationcenters.reports.ExaminationResultBatchStore'),
                fieldLabel: getPersonModuleTranslation('BATCH'),
                forceSelection: true,
                hidden: true
            }, {
                xtype: 'customcombobox',
                name: 'academicTerm',
                itemId: 'academicTermIdBulkUpload',
                fieldLabel: getPersonModuleTranslation('ACADEMIC_TERM'),
                editable: false,
                disabled: false,
                allowBlank: false,
                store: Ext.create('Academia.store.examinationcenters.manageEvaluation.evaluationgroup.AcademicTermByBatchStore'),
                valueField: 'id',
                displayField: 'code',
                listConfig: {
                    listeners: {
                        beforeshow: function (picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                            picker.maxWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function () {
                        return '<div class="search-item">' +
                            '{code}' +
                            '</div>';
                    }
                }
            }, {
                xtype: 'customcombobox',
                name: 'period',
                itemId: 'periodIdBulkUpload',
                fieldLabel: getPersonModuleTranslation('PERIOD'),
                editable: false,
                disabled: true,
                allowBlank: false,
                valueField: 'id',
                displayField: 'value',
                queryMode: 'local',
                forceSelection: true,
                listeners: {
                    render: function (combo) {
                        var store = Ext.create('Academia.store.examinationcenters.manageEvaluation.evaluationgroup.studentPeriodExaminationTableStore');
                        store.setProxy({
                            type: 'rest',
                            api: {
                                read: SERVERURL.PATH_FIND_PERIOD_BY_ACADEMIC_TERM_ID
                            },
                            reader: {
                                type: 'json'
                            }
                        })
                        combo.bindStore(store);
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getPersonModuleTranslation('STATUS'),
                store: Ext.create('Academia.store.student.studentprofile.AcademicTopicStatusStore'),
                name: 'status',
                itemId: 'statusBulkUpload',
                displayField: 'value',
                valueField: 'code',
                editable: false
            }, {
                xtype: 'checkboxfield',
                boxLabel: getPersonModuleTranslation('PUBLISH_ON_STUDENT_OR_PARENT_PORTAL'),
                name: 'isPublished',
                itemId: 'isPublishBulkUpload',
                inputValue: true,
                uncheckedValue: false,
                margin: '26 0 0 0'
            }]
        }, {
            xtype: 'fieldcontainer',
            items: [{
                xtype: 'button',
                name: 'academicTopicDocumentBulkUpload',
                text: getExaminationTranslation('UPLOAD_FILES'),
                itemId: 'academicTopicDocumentBulkUpload',
                ui: 'CustomBtnThird',
                scale: CONSTANTS.BUTTONSIZE,
                cls: 'btn-with-no-icon'
            }]
        }, {
            xtype: 'bulkAcademicTopicDocumentGrid',
            width: 725,
            bodyStyle: 'padding: 0',
            margin: '8 10 20 0',
            hidden: true
        }, {
            xtype: 'fieldcontainer',
    		layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'searchButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('RESET'),
                ui: 'CustomBtnCancel',
                itemId: 'resetButtonId',
                scale: CONSTANTS.BUTTONSIZE
            }, {
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'submitButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true,
                margin: '0 0 0 16'
            }]
        }
    ]
});