/**
 * @author Amit G
 */
Ext.define('Academia.view.student.currentEnrollmentReport.StudentCurrentEnrollmentReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.studentcurrentenrollmentreportfilter',
	autoScroll:false,
	cls:'customSearchPanel',
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items :[{
			xtype : 'multiselectcombofield',
			name : 'academyLocation',
			itemId:'academyLocationId',
			width: 536,
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			valueField : 'id',
			displayField : 'value',
			allowBlank : false,
			queryParam:'qry',
			typeAhead:true,
			enableKeyEvents  : 'true',
			hideTrigger:false,
			editable:false,
			forceSelection:true,
			cls:'commonAutoHeightMultiselectField',
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items :[{
			xtype: 'customcombobox',
			//xtype: 'combo',
			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
			itemId: 'programGroup',
			name: 'programGroup', 
			store: Ext.create('Academia.store.admission.applicationFormSale.ProgramGroupComboStore'),
			valueField:'id',
			displayField:'value',
			editable: false
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			itemId: 'programCodeName',
			name: 'programCodeName',
			store:'program.ProgramByGroupIdStore',
			valueField:'id',
			displayField:'valueCode',
			queryParam:'qry',
			disabled:true,
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getExaminationTranslation('RESET'),
			itemId: 'resetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}
		]
	}]
});
