/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.student.demographicReport.StudentDemographicsReportFilter',{
	extend:'Ext.form.Panel',
	alias:'widget.studentdemographicsreportfilter',
	autoScroll:false,
	plugins:"formlabelrequired",
	cls:'customSearchPanel',
	/*items:[{
		xtype:'form',*/
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('INTAKE_YEAR'),
				name : 'intakeYear',
				itemId : 'intakeYear',
				displayField:'value',
				valueField:'id',
				width: 256,
				typeAhead:true,
				forceSelection:true,
				minChars:3,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				},
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.IntakeYearStore');
						combo.bindStore(store)
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'programCategory',
				itemId : 'programCategory',
				fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
//				store:'program.ProgramCategoryStore',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				hidden: false,
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.program.ProgramCategoryStore');
						combo.bindStore(store)
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'programGroup',
				itemId:'programGroup',
				fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
				editable: true,
				valueField: 'id',
				displayField: 'value',
				forceSelection:true,
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.program.ProgramGroupStore');
						combo.bindStore(store)
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				fieldLabel: getPersonModuleTranslation('CASTE_CATEGORY'),
				name: 'castCategory',
				itemId: 'castCategory',
				valueField: 'id',
				displayField: 'value',
				editable: false,        		
				forceSelection :true,
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.CastCategoryStore');
						combo.bindStore(store)
					}
				}
			},{
				xtype: 'customcombobox',
				fieldLabel: getPersonModuleTranslation('RELIGION'),
				name: 'religion',
				itemId: 'religion',
				valueField: 'id',
				displayField: 'value',
//				queryMode: 'local',
				store:'common.ReligionStore',
				editable: false,
//				listeners  :{
//					render : function(combo){
//						var store=Ext.create('Academia.store.common.ReligionStore');
//						combo.bindStore(store)
//					}
//				}
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('GENDER'), //Gender
				name: 'gender',
				itemId: 'gender',
				valueField: 'id',
				displayField: 'value',
				store: 'common.GenderTypeStore',
				//queryMode: 'local',
				editable: false,
			}]
		},{

			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256
			},
			items:[{
    			xtype: 'customcombobox',
    			fieldLabel: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
    			name: 'SEAT_TYPE',
    			itemId: 'seatType',
    			editable: false,
    			autoload: false,
    			store:'program.programDetails.programBatches.programSeatType.ProgramBatchSeatTypeStore',
    			valueField : 'id',
    			displayField : 'value',
    			queryMode : 'local'
    		},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'academicTerm',
				itemId : 'academicTerm',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				hidden : false,
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.AcademicTermStore');
						combo.bindStore(store)
					}
				}
			}]
		},{
			xtype:'fieldset',
			title:getServiceRequestTranslation('MORE_FILTERS'),
			layout:'vbox',
			frame:true,	
			collapsible:true,
			collapsed:true,
			width:'100%',
			defaults: {
				labelAlign: 'top',
				//width: 256
			},
			style: {
				marginTop: '40px!important',
				//marginLeft:'-10px !important'
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width: 256
				},
				items:[{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
					name : 'programId',
					itemId : 'programId',
					displayField:'valueCode',
					valueField:'id',
					width: 256,
					typeAhead:false,
					forceSelection:true,
					queryParam:'programName',
					minChars:3,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}'  +
							'</div>';
						}
					},
					listeners  :{
						render : function(combo){
//							var store=Ext.create('Academia.store.common.ProgramsByAcademyLocationsIds');
							var store=Ext.create('Academia.store.common.ProgramForBillStore');
							combo.bindStore(store)
						}
					}
				},{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('BATCH'),		
					name : 'batchId',
					itemId : 'batchId',
					displayField : 'value',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,
					hidden : false,
					disabled:true,
					listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.enquiry.AcademicBatchStore');
							combo.bindStore(store)
						}
					}
				}]
			},{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width: 256
				},
				items:[{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('PERIOD'),
					name : 'periodId',
					itemId : 'periodId',
					displayField : 'value',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,
					hidden : false,
					disabled:true,
					listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
							combo.bindStore(store)
						}
					}
				},{
					xtype: 'customcombobox',
					name:'sectionId',
					itemId: 'sectionId',
				    fieldLabel: getCourseTxCommonTranslation('SECTION'),
					displayField: 'sectionCode',
					valueField: 'sectionId',
					typeAhead:true,
					forceSelection:true,
					disabled:true,
					listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
							combo.bindStore(store)
						}
					}
				}]
			},{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width: 256
				},
				items:[{
					xtype: 'customcombobox',
					name: 'country',
					itemId: 'country',        		
					forceSelection :true,
					fieldLabel: getCommonTranslation('ADDRESS_COUNTRY'),
					valueField: 'id',
					displayField: 'countryName',
					listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.common.CountryStore');
							combo.bindStore(store)
						}
					}

				},{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('STATE'),
					name : 'state',
					itemId : 'state',
//					store:'organization.CountryRegionStore',
					valueField : 'id',
					displayField : 'countryRegionName',
					editable : false,
					valueNotFoundText:"",        		        						
					forceSelection :true,
					listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.organization.CountryRegionStore');
							combo.bindStore(store)
						}
					}
				},{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('ADDRESS_CITY'),
//					hiddenName : 'city',
					name : 'city',
					itemId : 'city',
//					store:'organization.CityStore',
//					store:'organization.CityByCountryRegion',
					valueField : 'id',
//					displayField : 'cityName',
					displayField : 'value',
					//editable : false,    
					valueNotFoundText:"",        		
					forceSelection :true,
					disabled : true,
					typeAhead : false,
//					minChars:3,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}'  +
							'</div>';
						}
					},
					listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.organization.CityByCountryRegion');
							combo.bindStore(store)
						}
					}
				}]
			}]
		},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout : {
    			type : 'hbox'
    		},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				//formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	//}]
});
