/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.student.demographicReport.StudentDemographicsReportGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentdemographicsreportgrid',
	store: 'student.report.StdDemographicReportGridStore',
	title: getPersonModuleTranslation('STUDENT_DEMOGRAPHIC_REPORT'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.report.StdDemographicReportGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		text:getCommonTranslation('EXPORTREPORTS'),
		itemId:'exportReportsId',
		tooltip :getCommonTranslation('EXPORTREPORTS')
	}],
	columns: [{
		header:  getCommonTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.1
	},{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1
	},{
		header:  getCommonTranslation('STUDENT_FIRST_NAME'),
		dataIndex: 'studentFirstName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('STUDENT_MIDDLE_NAME'),
		dataIndex: 'studentMiddleName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('STUDENT_LAST_NAME'),
		dataIndex: 'studentLastName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('SEAT_TYPE'),
		dataIndex: 'seatType',
		flex:.1
	},{
		header:  getCommonTranslation('CASTE_CATEGORY'),
		dataIndex: 'studentCategory',
		flex:.1
	},{
		header:  getCommonTranslation('RELIGION'),
		dataIndex: 'religionName',
		flex:.1
	},{
		header:  getCommonTranslation('GENDER'),
		dataIndex: 'genderCSM',
		flex:.1,
		/*	renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.gender=="MALE")
				{	
				 return getCommonTranslation("Male");
				} else {
				 return getCommonTranslation("Female");
			  }
		  }
		}*/
	},{
		header:  getCommonTranslation('PROGRAM_CATEGORY'),
		dataIndex: 'programCategory',
		flex:.1
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1
		//hidden:true,
	},{
		header:  getCommonTranslation('SECTION'),
		dataIndex: 'sectionCode',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('INTAKE_YEAR'),
		dataIndex: 'intakeYear',
		flex:.1
	},{
		header:  getCommonTranslation('ACADEMIC_TERM'),
		dataIndex: 'academicTerm',
		flex:.1
	},{
		header:  getCommonTranslation('STATE'),
		dataIndex: 'state',
		hidden:true,
		flex:.1
	},{
		header:  getCommonTranslation('CITY'),
		dataIndex: 'city',
		flex:.1,
		hidden : true
	}]
});
