/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.student.disciplinaryActionSUReport.StudentDisciplinaryActionsSUReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.studentdisciplinaryactionssureportfilter',
	autoScroll:false,
	frame:false,
	standardSubmit:false,
	cls:'customSearchPanel',
	plugins:"formlabelrequired",
	/*style: 'margin: 0 16px !important',
	items:[{
		xtype:'form',
		cls:'customSearchPanel',*/
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype: 'customcombobox',
				name:'studentId',
				itemId:'studentIdItemId',
				store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentIdByAdmissionCodeBySmartSearch',
				fieldLabel : getCommonTranslation('STUDENT_ADMISSION_ID_CODE_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				width:490,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value} / {code}' +
						'</div>';
					}
				}
			},{
				xtype : 'customcombobox',
				name : 'programGroupCombo',
				itemId: 'programGroupComboItemId',
				fieldLabel : getCommonTranslation('DISCIPLINARY_ACTION_REPORT_PROGRAM_GROUP'),
				store: 'admission.applicationFormSale.ProgramGroupComboStore',
				valueField: 'id',
				forceSelection:true,
				displayField: 'value',
				editable: false
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:240
				},
				items:[{
					xtype: 'customcombobox',
					name:'PROGRAM_NAME',
					itemId:'programIdItemId',
					fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'name',
					minChars:3,
					store:'common.AssignedProgramStore',
					allowBlank: true,
					typeAhead:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					forceSelection:true,
					 listeners: {
    						render: function(combo) {
		                         //var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
		                    	  var store = Ext.create('Academia.store.common.AssignedProgramStore');
		                         combo.bindStore(store);
		                     }
    					}
					 	, listConfig: {
			                listeners: {
			                    beforeshow: function(picker) {
			                    picker.minWidth = picker.up('combobox').getSize().width;
			                    }
			                    },
			                    loadingText: getCommonTranslation('SEARCHING'),
			                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                    getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{code} / {value}'+
			                    '</div>';
			                    }
			                    }	    		
				},{
					xtype: 'customcombobox',
					name: 'BATCH_NAME',
					itemId: 'batchItemId',
					fieldLabel: getPersonModuleTranslation('BATCH'),
					disabled:true,
					editable: false,
					queryMode: 'local',
					displayField: 'value',
					valueField: 'id',
					listeners: {
						render: function(combo) {
							//var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
							var store = Ext.create('Academia.store.common.CurrentBatchStore');
							combo.bindStore(store);
						}
					}
				},{
					xtype: 'customcombobox',
					itemId:'periodItemId',
					disabled:true,
					editable: false,
					displayField: 'value',
					valueField: 'id',
					queryMode: 'local',
					fieldLabel: getPersonModuleTranslation('PERIOD'),
					name: 'PERIOD_NAME',
					listeners: {
						render: function(combo) {
							var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
							combo.bindStore(store);
						}
					}
				}]
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:240
				},
				items:[{
					xtype: 'customcombobox',
					name: 'SECTION',
					itemId: 'sectionItemId',
					disabled:true,
					fieldLabel: getPersonModuleTranslation('SECTION'),
					editable: false,
					queryMode: 'local',
					valueField: 'sectionId',
					displayField: 'sectionCode',
					listeners: {
						render: function(combo) {
							var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
							combo.bindStore(store);
						}
					}
				},{
					xtype:'nestedJsonCombo',
					fieldLabel:getPersonModuleTranslation('TYPE_OF_MISCONDUCT'),
					name:'typeOfMisconduct',
					itemId : 'typeOfMisconductItemId',
					store:'personinfo.common.disciplinaryactivity.DisciplinarySUTypeOfMisconductSearchCombo',
					forceSelection: true,
					valueField: 'id',
					displayField: 'value',
					//editable: false,
				}]
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:240
				},
				items:[{
					xtype: 'datefield',
					name: 'fromDate',
					itemId:'fromDateItemId',
					allowBlank:true,
					maxValue: new Date(),
					vtype: 'daterange',
					endDateField: 'toDateItemId',
					editable:false,
					fieldLabel: getPersonModuleTranslation('FROM_DATE')
				},{
					xtype: 'datefield',
					name: 'toDate',
					itemId:'toDateItemId',
					allowBlank:true,
					vtype: 'daterange',
					startDateField: 'fromDateItemId',
					editable:false,
					maxValue: new Date(),
					fieldLabel: getCommonTranslation('TO_DATE'),  
				},{
					xtype: 'customcombobox',
					fieldLabel: getPersonModuleTranslation('SANCTION_TYPE'),
					itemId: 'sanctionTypeItemId',
					name: 'sanctionType',
					store:'personinfo.common.disciplinaryactivity.DisciplinarySanctionTypeSUStore',
					queryParam:'term',
					triggerAction: 'all',
					forceSelection: true,
					displayField: 'value', 
					valueField: 'id',
				}]
			}]
		},
		{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:240
				},
				items:[{
					xtype: 'datefield',
					name: 'recallDate',
					itemId:'recallDateItemId',
					allowBlank:true,
					fieldLabel: getPersonModuleTranslation('SANCTION_RECALL_DATE'),
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					}
				}]
			}]
		},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout : {
    			type : 'hbox'
    		},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtnSUItemID',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				//formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtnSUItemId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	//}]
});