/**
 * @author priyanshi sharma
 * 
 *
 */
Ext.define('Academia.view.student.feeRegistrationFormSetup.FeeRegistrationFormSetupWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.feeregistrationformsetupwindow',
    modal: true,
    resizable: false,
    autoScroll:true,
    title: getCommonTranslation('FEE_REGISTRATION_FORM_SETUP'),
	height: 600,
	width: 800,
    items: [{
        xtype: 'form',
        itemId: 'feeRegFormSetupForm',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'feeRegFormHiddenField',
            name: 'id'
        },{
        	xtype: 'fieldcontainer',
        	layout: {
        		type: 'hbox'
        	},
        	defaults: {
        		labelAlign: 'top',
        		width: 256
        	},
        	items: [{
        		xtype: 'customcombobox',
        		name: 'feeRegSetupFormAcademy',
        		itemId: 'feeRegSetupFormAcademyItemId',
        		fieldLabel: getCommonTranslation('ACADEMY'),
        		displayField: 'value',
        		valueField: 'id',
        		queryParam: 'name',
        		store:Ext.create('Academia.store.student.feeRegistrationFormSetup.FeeRegFormSetupAcademyStore'),
        		minChars: 3,
        		allowBlank:false,
        		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        		triggerAction: 'all',
        		forceSelection: true,
        		listConfig: {
        			listeners: {
        				beforeshow: function(picker) {
        					//picker.minWidth = picker.up('combobox').getSize().width;
        					var combo = picker.up('combobox');
                    		picker.setWidth(combo.getWidth());
        				}
        			},
        			loadingText: getCommonTranslation('SEARCHING'),
        			emptyText: getCommonTranslation('NO_RECORDS_FOUND')
        		}
        	},{
                xtype:'panel',
                cls : 'panelNoSpace',
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                items:[{
            		xtype: 'multiselectcombofield',
            		name: 'feeRegSetupFormLocation',
            		itemId: 'feeRegSetupFormLocationItemId',
            		fieldLabel: getCommonTranslation('LOCATION'),
            		displayField: 'locationName',
            		valueField: 'locationId',
            		store:Ext.create('Academia.store.student.feeRegistrationFormSetup.FeeRegFormSetupLocationStore'),
            		cls:'commonAutoHeightMultiselectField multiBrandCampusCls',
            		allowBlank:false,
            		forceSelection: true,
            		disabled:true,
            		listConfig: {
            			listeners: {
            				beforeshow: function(picker) {
            					//picker.minWidth = picker.up('combobox').getSize().width;
            					var combo = picker.up('combobox');
                        		picker.setWidth(combo.getWidth());
            				}
            			},
            			loadingText: getCommonTranslation('SEARCHING'),
            			emptyText: getCommonTranslation('NO_RECORDS_FOUND')
            		}
            	}]
        	}]
        },{
        	xtype: 'fieldcontainer',
        	layout: {
        		type: 'vbox'
        	},
        	defaults: {
        		xtype:'textareafield',
        		labelAlign: 'top',
        		width: 700,
	            enforceMaxLength : true,
	            maxLength : 180,
        	},
        	 items: [{
        		 autoScroll:true,
        		 fieldLabel:getCommonTranslation('REGISTRATION_POP_UP_CONTENT'),
        		 name:'regPopupContent',
        		 itemId:'regPopupContentItemId',
        		 height:400,
        		 maxLength : 2500
        	 },{
        		 xtype:'displayfield',
        		 name:'htmlTagTextField',
        		 itemId:'htmlTagTextField',
        		 value: '<span style="color: #2e2e2e;font: normal 13px / 17px \'Open Sans\', sans-serif, Myriad Pro;">'+getCommonTranslation('HTML_TAG_SUPPORTED')+'</span>',
        	 },{
        		 fieldLabel:getCommonTranslation('FINANCE_CLAUSE'),
        		 name:'financeClause',
        		 itemId:'financeClauseItemId',
        		 height:150,
        		 maxLength : 2500
        	 },{
        		 fieldLabel:getCommonTranslation('DOCUMENT_CHECKBOX_CONTENT1'),
        		 name:'docCheckBoxContentFirst',
        		 itemId:'docCheckBoxContentFirst',
        		 style:{
        			 marginTop:'17px !important'
        		 }
        	 },{
        		 fieldLabel:getCommonTranslation('DOCUMENT_CHECKBOX_CONTENT2'),
        		 name:'docCheckBoxContentSecond',
        		 itemId:'docCheckBoxContentSecond'
        	 },{
        		 fieldLabel:getCommonTranslation('DOCUMENT_CHECKBOX_CONTENT3'),
        		 name:'docCheckBoxContentThird',
        		 itemId:'docCheckBoxContentThird',
        		 hidden:true
        	 },{
        		 fieldLabel:getCommonTranslation('DOCUMENT_CHECKBOX_CONTENT4'),
        		 name:'docCheckBoxContentFourth',
        		 itemId:'docCheckBoxContentFourth',
        		 hidden:true
        	 },{
        		 fieldLabel:getCommonTranslation('DOCUMENT_CHECKBOX_CONTENT5'),
        		 name:'docCheckBoxContentFifth',
        		 itemId:'docCheckBoxContentFifth',
        		 hidden:true
        	 },{
        		 fieldLabel:getCommonTranslation('DOCUMENT_CHECKBOX_CONTENT6'),
        		 name:'docCheckBoxContentSixth',
        		 itemId:'docCheckBoxContentSixth',
        		 hidden:true
        	 }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                itemId: 'btnSaveFeeRegSetupForm',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelFeeRegSetupForm',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});
