/**
 * @author Kamini Birla
 */
Ext.define('Academia.view.student.healthInformationReport.StudentHealthInformationReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.studenthealthinformationreportfilter',
	autoScroll:false,
	frame:false,
	standardSubmit:false,
	cls:'panelNoSpace',
	plugins:"formlabelrequired",
	style: 'margin: 0 16px !important',
	items:[{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256
			},
			items:[{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
					name : 'ACADEMIC_TERM_ID',
					itemId : 'academicTerm',
					displayField : 'value',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,
					allowBlank: false,
					hidden : false,
					listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.student.report.AcademicTermForCommunityStore');
							combo.bindStore(store)
						}
					}
				},{
		            xtype: 'customcombobox',
					fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
		            name: 'academyLocation',
		            itemId:'academyLocationId',
		            store: 'user.UserAcademyLocationStore',
		            displayField: 'value',
		            valueField: 'id',
		            width: 536,
		            typeAhead : false,
		            forceSelection:true,
		            hideTrigger:false,
		            queryMode: 'remote',
		            queryParam: 'qry',
		    	    triggerAction: 'all',
		            listConfig: {
						  listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			                loadingText: getCommonTranslation('SEARCHING'),
			                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			                getInnerTpl: function() {
			                    return '<div class="search-item">' +
			                    '{value}'  +
			                    '</div>';
			                }
			            }
		        }]
		
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256
			},
				items:[{
					xtype: 'multiselectcombofield',
					name:'program',
					store : Ext.create('Academia.store.student.report.ProgramWithAcademicTermStore'),
					itemId:'programId',
					fieldLabel: getCommonTranslation('PROGRAM'),
					valueField: 'id',
					displayField: 'valueCode',
					hideTrigger:false,
					_isStoreLoadCalled:true,
					forceSelection : true,
					cls:'commonAutoHeightMultiselectField',
					triggerAction: 'all',
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{programCode} / {programName}' +
							'</div>';
						}
					}

				}, {  
					xtype: 'multiselectcombofield',
					fieldLabel: getCommonTranslation('BATCH'),
					name: 'batch',
					itemId: 'batchId',
					store: Ext.create('Academia.store.program.programbatchdetail.BatchStore'),
					displayField: 'value',
					valueField: 'id',
					_isStoreLoadCalled:true,
					typeAhead: false,
					forceSelection: true,  
					cls:'commonAutoHeightMultiselectField',  
					hideTrigger: false,
					triggerAction: 'all',
					disabled:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{batchName}' +
							'</div>';
						}
					}
				},{
					xtype: 'multiselectcombofield',
					name: 'period',
					itemId: 'periodId',
					_isStoreLoadCalled:true,
					fieldLabel:getCommonTranslation('PERIOD'),
					store:Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
					queryParam: "qry",
					cls:'commonAutoHeightMultiselectField',
					valueField : 'id',
					forceSelection : true,
					displayField : 'value',
					hideTrigger:false,
					typeAhead:true,
					triggerAction: 'all',
					disabled:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{periodName}' +
							'</div>';
						}
					}
				}]
		},,{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256	
			},
			items:[{
				xtype: 'customcombobox',
				name: 'STUDENT_ID',
				itemId:'studentId',
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: 'feeandpayment.managebill.Student',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
            },{  
				xtype: 'multiselectcombofield', 
				fieldLabel: getCommonTranslation('MEDICAL_INDICATORS'),
				name: 'medicalIndicator',
				itemId: 'medicalIndicatorId',
				store:Ext.create('Academia.store.common.MedicalIndicatorsStore'),
				displayField: 'value',
				valueField: 'id',
				typeAhead: false,
				forceSelection: true,  
				cls:'commonAutoHeightMultiselectField',
				hideTrigger: false,
				triggerAction: 'all',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{batchName}' +
						'</div>';
					}
				}
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout : {
    			type : 'hbox'
    		},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	}]
});