Ext.define('Academia.view.student.postGraduateManagement.IndependentNonExaminingChairpersonReportGrid', {
	alias: 'widget.independentnonexaminingchairpersonreportgrid',
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    title: getCommonTranslation('INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT'),
    border: true,
    
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode: true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode: true
    },{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }],
    columns : [{
    	header: getCommonTranslation('AUDIT_ID'),
		dataIndex: 'auditId',
		ItemId: 'auditIdItem',
		flex: 1.5,
		sortable: true,
		hidden:false,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.auditId.code;
			}                        
		}
	},{
        header: getCommonTranslation('AUDIT_DATE'),
        dataIndex: 'auditDate',
        ItemId: 'auditDateItem',
        sortable: true,
        hidden:false,
        flex: 1.5 ,
        renderer : function(value){
       		return  dateRender(value);   	
        }
    }, {
		header : getPersonModuleTranslation('UPLOAD_DOCUMENT'),
		dataIndex: 'independentNonExaminingChairPersonDocs',
		flex:1,
		sortable:true,
		renderer:function(value, meta, record){
			console.log('record='+record)
			if(!isNullOrEmpty(value)) {
				if(record.data.independentNonExaminingChairPersonDocs.length>1) {					
					return '<a href=#>'+record.data.independentNonExaminingChairPersonDocs.length+'<a>';
				} else if(record.data.independentNonExaminingChairPersonDocs.length==1) {
					return '<a href=#>'+record.data.independentNonExaminingChairPersonDocs[0].name+'<a>';
				} 
			}                        
		}
	}],
    		initComponent: function() {
    	        var this$ = this;
    	        var store = this$.buildStore();
    	        Ext.apply(this$, {
    	            store: store,
    	            dockedItems: [{
    	                xtype: 'toolbar',
    	                dock: 'bottom',
    	                items: [{
    	                    xtype: 'custompagingtoolbar',
    	                    plugins: ['pagesize'],
    	                    store: store,
    	                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    	                    displayInfo: true
    	                }]
    	            }]
    	        });
    	        this$.addExportToolBarItems(this$);
    	        this$.callParent(arguments);
    	    },
    		buildStore: function() {
    			return Ext.create('Academia.store.student.postGraduateManagement.IndependentNonExaminingChairpersonReportStore');
    		}
});