/**
 * @author Prakash Soni
 */
Ext.define('Academia.view.student.studentFeePayerReport.StudentFeeRegistrationReport', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentfeeregistrationreport',
	autoScroll: false,
	cls:'customSearchPanel',
    plugins:"formlabelrequired",
	//items: [{
	//	xtype:'form',
		//cls:'panelNoSpace customSearchInnerPanel',
		items:[{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'multiselectcombofield',
				width: 960,
				height:58,
				name: 'multiselectAcademyId',
				itemId: 'multiselectAcademyId',
				allowBlank : false,
				fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
				displayField:'value',
				valueField:'id',
				matchFieldWidth:true,
				maxLength:15000,
				autoloadStore: false,
				queryMode:'local',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				},
	        	listeners  :{
	        		render : function(combo){
	        			var store=Ext.create('Academia.store.common.AcademyLocationNameSeparated');
	        			combo.bindStore(store)
	        		}
	        	}
			}]},
			{
				xtype: 'fieldcontainer',
	            layout: 'hbox',
	            defaults: {
	                labelAlign: 'top',
	                width: 256
	            },
				items: [{
			    	xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('INTAKE_YEAR'),
					name : 'intakeYear',
					itemId : 'intakeYear',
					displayField:'value',
					valueField:'id',
					width: 256,
					allowBlank : false,
					typeAhead:true,
					forceSelection:true,
					minChars:3,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}'  +
							'</div>';
						}
					},
					listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.common.IntakeYearStore');
							combo.bindStore(store)
						}
					}
				},{
					xtype: 'multiselectcombofield',
					name: 'programCategory',
					itemId : 'programCategory',
					fieldLabel: getCommonTranslation('PROGRAM_CATEGORY'),
					store:'program.ProgramCategoryStore',
					displayField:'value',
					valueField:'id',
					width: 536,
					typeAhead:true,
					forceSelection:true,
					autoloadStore: false,
					hidden : false,
					cls:'receiptHeaderMultiselect'
					
				}]	 
		            
			}
			,{
				xtype:'fieldset',
				title:getServiceRequestTranslation('MORE_FILTERS'),
				collapsible:true,
				collapsed:true,
				width:'100%',
				items:[{
				    xtype: 'fieldcontainer',
				    layout: 'hbox',
				    defaults: {
				        labelAlign: 'top',
				        width: 256
				    },
				    items: [{
		             	xtype: 'customcombobox',
		                 name: 'programGroupId',
		                 itemId:'programGroupId',
		                 fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
		                 store:'Academia.store.common.AssignedProgramGroupStore',
		                 displayField:'value',
		                 valueField:'id',
		                 forceSelection:true
		             },{
		            	 xtype: 'customcombobox',
			    			name:'program',
			    			store: 'Academia.store.common.ProgramForBillStoreFeePayment',
			    			itemId:'program',
			    			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			    			valueField: 'id',
			    			displayField: 'valueCode',
			    			queryParam:'programName',
			    			minChars:3,
			    			allowBlank: true,
			    			typeAhead:false,
			    			width: 536,
			                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			                forceSelection:true,
			    			  listConfig: {
			    				  listeners: {
			    						beforeshow: function(picker) {
			    							picker.minWidth = picker.up('combobox').getSize().width;
			    						}
			    					},
			    	                loadingText: getCommonTranslation('SEARCHING'),
			    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			    	                getInnerTpl: function() {
			    	                    return '<div class="search-item">' +
			    	                        '{code} / {value}'+ 
			    	                    '</div>';
			    	                }
			    	            }
			    		
			            }]
				},{
		            xtype: 'fieldcontainer',
		            layout: 'hbox',
		            defaults: {
		                labelAlign: 'top',
		                width: 256
		            },
		            items: [{
		                 xtype: 'customcombobox',
		                 name: 'batch',
		                 itemId: 'batch',
		                 fieldLabel: getPersonModuleTranslation('BATCH'),
		                 queryMode: 'local',
		                 displayField: 'value',
		                 valueField: 'id',
		             	 typeAhead : true,
		             	 disabled:true,
						 forceSelection : true,
				
		                 listeners: {
		                     render: function(combo) {
		                         var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
		                         combo.bindStore(store);
		                     }
		                 }
		             },{
		     			xtype: 'customcombobox',
		     			name:'studentIdName',
		     			itemId:'studentIdName',
		     			fieldLabel : getCommonTranslation('STUDENT_ADMISSION_ID_CODE_NAME'),
		     			valueField: 'id',
		     			displayField: 'valueCode',
		     			queryParam:'name',
		     			minChars:3,
		     			typeAhead:false,
		     			width: 536,
		     			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		     			enableKeyEvents  : 'true',
		     			hideTrigger:false,
		     			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		     			triggerAction: '',
		     			forceSelection:true,
		     			listConfig: {
		     				listeners: {
		     					beforeshow: function(picker) {
		     						picker.minWidth = picker.up('combobox').getSize().width;
		     					}
		     				},
		     				loadingText: getCommonTranslation('SEARCHING'),
		     				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		     				getInnerTpl: function() {
		     					return '<div class="search-item">' +
		     					'{value} / {code}' +
		     					'</div>';
		     				}
		     			},
		     			listeners  :{
			        		render : function(combo){
			        			var store=Ext.create('Academia.store.reports.student.StudentByIdAdmissionIDNameStore');
			        			combo.bindStore(store)
			        		}
			        	}
		             }]
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 256
					},
					items: [{
						fieldLabel : getCommonTranslation('RE_REGISTRATION_STATUS'),
						xtype: 'customcombobox',
						name: 'status', 
						itemId:'status',
						store:'Academia.store.student.report.ReRegistrationStatusStore',
						valueField:'name',
						displayField:'value',
						editable:false,
						queryMode:'local'            
					}]
				}]
			},{
				xtype: 'fieldcontainer',
				width: '100%',
	    		layout : {
	    			type : 'hbox'
	    		},
	    		cls: 'customSearchPanelBtnsFieldContainerCls',
				items: [{
					xtype: 'button',
					text: getCommonTranslation('SEARCH'),
					itemId: 'btnSearch',
					formBind : true,
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE,
					margin: '0 16 0 0'
				},{
					xtype: 'button',
					text: getCommonTranslation('RESET'),
					itemId: 'btnReset',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE   
				}]	
			}]
//	}]

});