/**
 * @author Hareesh Soni
 */
Ext.define('Academia.view.student.studentIdentityDocumentReport.StudentIdentityDocumentReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.studentidentitydocumentreportfilter',
	autoScroll:false,
	frame:false,
	standardSubmit:false,
	cls:'customSearchPanel',
	plugins:"formlabelrequired",
	/*style: 'margin: 0 16px !important',
	items:[{
		xtype:'form',
		cls:'customSearchPanel',*/
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype : 'customcombobox',
				name : 'identityDocumentType',
				itemId:'identityDocumentTypeId',
				fieldLabel : getPersonModuleTranslation('ID_TYPE'),
				//store : 'personinfo.common.personalinfo.IdentityTypeStore',
				valueField : 'id',
				editable : false,
				displayField : 'value',
				fourceSelection: true,
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.personinfo.common.personalinfo.IdentityTypeStore');
						combo.bindStore(store)
					}
				}
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'ACADEMIC_TERM_ID',
				itemId : 'academicTerm',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				hidden : false,
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.student.report.AcademicTermForCommunityStore');
						combo.bindStore(store)
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'STUDENT_ID',
				itemId: 'studentId',
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				},
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.feeandpayment.managebill.Student');
						combo.bindStore(store)
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype : 'customcombobox',
				name : 'PROGRAM_GROUP_ID',
				itemId : 'Program_Group',
				fieldLabel : getCommonTranslation('PROGRAM_GROUP_NAME'),
				valueField : 'id',
				displayField : 'value',
				forceSelection : true,
	            editable: false,
	            listeners: {
	                render: function(combo) {
	                	 var store = Ext.create('Academia.store.personinfo.common.personalinfo.AttendanceReportProgramGroupStore');
	                   // var store = Ext.create('Academia.store.admission.applicationFormSale.ProgramGroupComboStore');
	                    combo.bindStore(store);
	                }
	            }
			
	        },{
				xtype: 'customcombobox',
				name:'programName',
				itemId:'programId',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'programName',
				minChars:3,
				allowBlank: true,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				forceSelection:true,
				 listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
								'{code} / {value}'+ 
							'</div>';
						}
				},
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.student.report.ProgramWithAcademicTermStore');
						combo.bindStore(store)
					}
				}
	        },{
	        	xtype: 'customcombobox',
	        	name: 'BATCH_NAME',
	        	itemId: 'batchId',
	        	store: Ext.create('Academia.store.program.programbatchdetail.BatchStore'),
	        	fieldLabel: getPersonModuleTranslation('BATCH'),
	        	disabled:true,
	        	//editable: false,
	        	//queryMode: 'local',
	        	displayField: 'value',
	        	queryParam:'batchName',
	        	valueField: 'id'
	        }]
		},{

			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name:'PERIOD_NAME',
				itemId:'periodId',
				store: 'student.report.studentIdentityDocumentReport.PeriodNameSearchStore',
				disabled:true,
				//editable: false,
				displayField: 'value',
				queryParam:'periodName',
				valueField: 'id',
				//queryMode: 'local',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				fieldLabel: getPersonModuleTranslation('PERIOD'),
				forceSelection:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'+ 
						'</div>';
					}
				}
			},{
	            xtype: 'customcombobox',
	            name: 'SECTION_ID',
	            itemId: 'section',
	            fieldLabel: getPersonModuleTranslation('SECTION'),
	            editable: false,
	            valueField: 'id',
	            disabled:true,
	            displayField: 'value',
	            listeners: {
	                render: function(combo) {
	                    var store = Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionMultiSelect');
	                    combo.bindStore(store);
	                }
	            }
	        }]
		
		},{
			xtype:'fieldset',
			title:getServiceRequestTranslation('MORE_FILTERS'),
			layout:'vbox',
			frame:true,	
			collapsible:true,
			collapsed:true,
			width:'100%',
			defaults: {
				labelAlign: 'top'
			},
			style: {
				marginTop: '40px!important',
			},
			items:[{
		    	xtype : 'fieldcontainer',
		    	width: '100%',
		    	defaults : {
		    		width: 256,
		    		labelAlign : 'top'
		    	},
		    	items : [{
		    		xtype:'displayfield',
		    		value:'<b class="menu-title">'+getCommonTranslation('ISSUING_DETAILS')+'</b>',
		    		style: {
		    			textDecoration: "underline"
		    		}
		    	},{ 
		    		xtype : 'fieldcontainer',
		    		width: '100%',
		    		layout:'hbox',
		    		defaults : {
		    			width: 256,
		    			labelAlign : 'top'
		    		},
		    		items : [{
		    			xtype : 'datefield',
		    			fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
		    			name : 'issuingFromDate',
		    			itemId:'issuingFromDateId',
		    			endDateField : 'issuingToDateId',
		    			listeners: {
		    				render: function(field) {
		    					return dateFormatRender(field);
		    				}
		    			},
		    			vtype : 'daterange'
		    		},{
		    			xtype : 'datefield',
		    			fieldLabel :getCommonTranslation('END_DATE'),
		    			name : 'issuingToDate',
		    			itemId : 'issuingToDateId',
		    			startDateField : 'issuingFromDateId',
		    			listeners: {
		    				render: function(field) {
		    					return dateFormatRender(field);
		    				}
		    			},
		    			vtype : 'daterange'
		    		}]
		    	}
		    	]},{

		        	xtype : 'fieldcontainer',
		        	width: '100%',
		        	defaults : {
		        		width: 256,
		        		labelAlign : 'top'
		        	},
		        	items : [{
		        		xtype:'displayfield',
		        		value:'<b class="menu-title">'+getCommonTranslation('VALIDITY_DETAILS')+'</b>',
		        		style: {
		        			textDecoration: "underline"
		        		}
		        	},{ 
		        		xtype : 'fieldcontainer',
		        		width: '100%',
		        		layout:'hbox',
		        		defaults : {
		        			width: 256,
		        			labelAlign : 'top'
		        		},
		        		items : [{
		        			xtype : 'datefield',
		        			fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
		        			name : 'validityFromDate',
		        			itemId:'validityFromDateId',
		        			endDateField : 'validityToDateId',
		        			listeners: {
		        				render: function(field) {
		        					return dateFormatRender(field);
		        				}
		        			},
		        			vtype : 'daterange'
		        		},{
		        			xtype : 'datefield',
		        			fieldLabel :getCommonTranslation('END_DATE'),
		        			name : 'validityToDate',
		        			itemId : 'validityToDateId',
		        			startDateField : 'validityFromDateId',
		        			listeners: {
		        				render: function(field) {
		        					return dateFormatRender(field);
		        				}
		        			},
		        			vtype : 'daterange'
		        		}]
		        	}
		        	]
		    	}]
		},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout : {
    			type : 'hbox'
    		},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	//}]
});