/**
 * @author Amit G
 */
Ext.define('Academia.view.student.studentServiceOptInReport.StudentServiceOptInReportGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentserviceoptinreportgrid',
	store: 'student.report.serviceOptInReport.StudentServiceOptInReportGridStore',
	title: getCommonTranslation('STUDENT_SERVICE_OPTIN_REPORT'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.report.serviceOptInReport.StudentServiceOptInReportGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},

	columns: [{
		header:  getCommonTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.1
	},{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1
	},{
		header:  getCommonTranslation('Period'),
		dataIndex: 'periodName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1
	},{
		header:  getCommonTranslation('SEAT_TYPE'),
		dataIndex: 'seatTypeName',
		flex:.1
	},{
		header:  getCommonTranslation('SERVICE_NAME'),
		dataIndex: 'serviceName',
		flex:.1
	},{
		header:  getCommonTranslation('SERVICE_OPT_IN_DATE'),
		dataIndex: 'serviceOptInDate',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return dateRender(val);
		}
	},
	{
		header:  getCommonTranslation('SERVICE_OPT_END_DATE'),
		dataIndex: 'serviceOptEndDate',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return dateRender(val);
		}
	}]
});
