/**
 * 
 * @author Amit G
 */
Ext.define('Academia.view.student.studentprofile.StudentPhysicalDocumentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentphysicaldocumentgrid',
	title: getPersonModuleTranslation('LIST_OF_PHYSICAL_DOCUMENTS'),
	border: true,
	enableColumnHide: false,
	selType:'checkboxmodel',
	style:{
		'margin':'25px !important'
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns: [{
		header: getPersonModuleTranslation('DOCUMENTS_NAME'),
		dataIndex: 'documentType',
		itemId: 'documentTypeItem',
		sortable: true,
		flex: .2,
		renderer: function(value, metadata, record) {
			var msg = "";
			if (!isNullOrEmpty(record.data.isPreDefined) && record.data.isPreDefined) {
				if (!isNullOrEmpty(value)) {
					msg = columnObjRender(value, "value");
				}
			} else {
				if (!isNullOrEmpty(record.data.documentName)) {
					msg = record.data.documentName;
				}
			}
			return msg;
		}
	}, {
		header: getPersonModuleTranslation('DOCUMENTS_TYPE'),
		dataIndex: 'documentApplicability',
		itemId: 'documentApplicabilityItem',
		sortable: true,
		flex: .2,
		hidden: true,
		renderer: function(obj) {
			return getAdmissionTranslation(obj);
		}
	}, {
		header: getPersonModuleTranslation('DATE_SUBMISSION'),
		dataIndex: 'submissionDate',
		sortable: true,
		flex: .2,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getPersonModuleTranslation('RETURNED_DATE'),
		dataIndex: 'returnedDate',
		itemId: 'returnedDateItem',
		sortable: true,
		flex: .2,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getPersonModuleTranslation('MODE_SUBMISSION'),
		dataIndex: 'modeOfSubmission',
		sortable: true,
		flex: .2,
		renderer: function(value) {
			if (!isNullOrEmpty(value)) {
				value = getPersonModuleTranslation(value);
			} else {
				value = '';
			}
			return value;
		}
	}, {
		header: getPersonModuleTranslation('INSPECTION_DATE'),
		dataIndex: 'inspectionDate',
		itemId: 'inspectionDateItem',
		sortable: true,
		flex: .2,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getAdmissionTranslation('PHYSICAL_DOCUMENT_STATUS'),
		dataIndex: 'documentStatusCSM',
		sortable: true,
		flex: .2,
		renderer: function(value, metadata, record) {
			if (!isNullOrEmpty(value)) {
				if (value.code == 'PENDING' || value.code == 'PENDING_OPTIONAL') {
					return '<span style="color:red;">' + value.value + '</span>';
				}else
					return value.value;
			}else
				return "";
		}
	}, {
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		sortable: true,
		flex: .2
	}, {
		header: getAdmissionTranslation('SEAT_TYPE'),
		dataIndex: 'seatType',
		sortable: true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('REMARK'),
		dataIndex: 'remark',
		sortable: true,
		flex: .2,
		renderer: function(value, metadata, record) {
			if (!isNullOrEmpty(value)) {
				return '<a href="#">View</a>';
			}
			return '';
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore(this$.personType);
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function(personType) {
		return Ext.create('Academia.store.student.studentprofile.StudentProfilePhysicalDocumentStore');
	}
});