/**
 * @author Niklesh Tiwane
 * 
 */
Ext.define('Academia.view.student.studentprofile.StudentTransferCreditRequestFilter', {
	extend : 'Ext.panel.Panel',
	alias : 'widget.studentTransferCreditRequestFilter',
	autoScroll:false,
	cls:'noPaddingPanel SearchTabPanelWithRightTabs panelNoSpace horizontalScrollingFixed',
	frame:false,
	cls:'customSearchPanel',
	plugins:"formlabelrequired",
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	defaults: {
		labelAlign: 'top',
	},
	items : [{
		xtype: 'fieldcontainer',
        width : '100%',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [
			
			{
				xtype: 'fieldcontainer',
		        width : '100%',
				layout: {
					type : 'hbox'
				},
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'customcombobox',
					fieldLabel:getExaminationTranslation('PROGRAM_CODE_NAME'),
					name:'stcrdProgram',
					itemId:'stcrdProgramItemId',
					store: Ext.create("Academia.store.student.studentprofile.StudentTransferCreditProgramStore"),
					forceSelection: true,
					valueField: 'id',
					displayField: 'valueCode',
					//queryParam:'programName',
					editable: true,
//					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
//					minChars:3,
					width: 380,
					allowBlank: false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					}	
				},{
					xtype: 'customcombobox',
					fieldLabel:getExaminationTranslation('BATCH'),
					store: Ext.create("Academia.store.student.studentprofile.StudentTransferCreditBatchStore"),
					name:'stcrdBatch',
					itemId:'stcrdBatchItemId',
					forceSelection: true,
					editable: true,			
					valueField: 'id',
					displayField: 'value',
					allowBlank: false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					}
				}]				
			},
		{
			xtype: 'fieldcontainer',    
			width:'90%',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			layout: 'hbox',
			items : [{
				xtype : 'button',
				text : getCommonTranslation("SEARCH") ,
				name : 'submitBtn',
				itemId : 'submitBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				name: 'resetBtn',
				text: getCommonTranslation("RESET"),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
			}]		
		}]
	}]
});