/**
 * @author Amit G
 */
Ext.define('Academia.view.student.succeedingEnrollmentReport.StudentSucceedingEnrollmentReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentsucceedingenrollmentreportgrid',
	store: 'student.studentenrollmentreport.StudentSucceedingEnrollmentStore',
	title: getCommonTranslation('SUCCEEDING_STUDENT_ENROLLMENT'),
	border: true,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		emptyText :getCommonTranslation('EMPTY_MESSAGE'),
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [/*{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			//store : 'student.report.StdDemographicReportGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}*/]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [],
	columns: [{
		header:  getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocationName',
		flex:.1,
	    sortable: false,
	    renderer:function(value, meta, record){
			if(record.data.isTotalRecord == true ){
				return '<b>'+value+'</b>';
			}else{
				return value;
			}
		}
	},{
		header:  getCommonTranslation('PROGRAM_GROUP'),
		dataIndex: 'programGroupName',
		flex:.1,
		hidden:true,
	    sortable: false
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('CONFIRMED_STUDENTS'),
		dataIndex: 'confirmedStudents',
		renderer:function(value, meta, record){
			if( value == 0 || value == '0' ){
				return '-';
			} else if(record.data.isTotalRecord == false ){
				return '<a href=#>'+value+'<a>';
			}else{
				return '<b>'+value+'</b>';
			}
		},
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('PROJECTED_PROMOTIONS'),
		dataIndex: 'projectedPromotions',
		renderer:function(value, meta, record){
			if( value == 0 || value == '0' ){
				return '-';
			} else if(record.data.isTotalRecord == false ){
				return '<a href=#>'+value+'<a>';
			}else{
				return '<b>'+value+'</b>';
			}
		},
		flex:.1,
	    sortable: false
	},{
		header:  getCommonTranslation('TOTAL_ENROLLMENT'),
		dataIndex: 'totalSucceedingEnrollments',
		renderer:function(value, meta, record){
			var confirmedStudentsStr = record.data.confirmedStudents;
			var projectedPromotionsStr = record.data.projectedPromotions;
			var confirmedStudents = parseInt(confirmedStudentsStr);
			var projectedPromotions = parseInt(projectedPromotionsStr);
			var returnValue = confirmedStudents + projectedPromotions;
			if( returnValue > 0 && record.data.isTotalRecord == false){
				return '<a href=#>'+returnValue+'<a>';
			}else if(returnValue > 0 && record.data.isTotalRecord == true){
				return '<b>'+returnValue+'</b>';
			} else {
				return '-';
			}
		},
		flex:.1,
	    sortable: false
	}]
});
