/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.studentPortal.SPStudentAssessmentReportFilter', {
	extend: 'Ext.form.FormPanel',
    alias: 'widget.spstudentassessmentreportfilter',
    autoScroll: false,
	cls:'customSearchPanel',
    standardSubmit : false,
    title: getCommonTranslation('SEARCH'),
    collapsible: true,
    modal: true,
    border:true,
    method: 'POST',
    plugins : "formlabelrequired",
    items: [{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
			xtype: 'customcombobox',
			name: 'program',
			itemId : 'programId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store : 'servicerequest.placementrequest.PlacementPrograms',
			displayField:'valueSecondValue',
			valueField:'programId',
			//allowBlank: false,		
			typeAhead : true,
            forceSelection:true,
            hideTrigger:false,  
    	    triggerAction: 'all',
    	    queryParam:'name',
            minChars:3,
			style:{marginLeft:'10px'},
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
		},{
			xtype: 'customcombobox',
			name: 'batch',
			itemId : 'batchId',
			fieldLabel: getCommonTranslation('BATCH'),
			store:'common.CurrentBatchStore',
        	displayField : 'value',
        	valueField : 'id',
        	forceSelection:true,
			typeAhead:true,
			//allowBlank: false,
			disabled : true
		},{
			xtype: 'multiselectcombofield',
			name: 'period',
			itemId : 'periodId',
			fieldLabel: getCommonTranslation('PERIOD'),
			store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
        	displayField : 'value',
        	valueField : 'id',
			maxLength:10000,
			forceSelection:true,
			autoloadStore: false,
			editable:false,
			typeAhead:true,
			disabled:true
		}]
    },{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
			xtype: 'multiselectcombofield',
			name: 'evalLevelName',
			itemId: 'evalLevelName',
			store:'examinationcenters.assessmentEvent.StudentAssessmentLevelNameListStore',
			fieldLabel:getExaminationTranslation('EVALUATION_LEVEL_NAME'),
			displayField:'value',
			valueField:'id',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			allowBlank:false,
			forceSelection:true,
			//disabled:true,
			width: 536,
			style:{marginLeft:'10px'},
			cls:'commonAutoHeightMultiselectField',
			maxLength:9999,
			maxSelections :9999,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
    	
        }]
    },
    {
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
			xtype: 'customcombobox',
			name: 'course',
			style:{marginLeft:'10px'},
			itemId:'course_Id',
			store:'examinationcenters.remark.CourseEvaluationRemarkForSP',  
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'), 
			queryParam:'name',
			disabled : true,
			valueField: 'courseId',
			displayField: 'courseCode',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			hideTrigger:false,
			minChars:3,
			forceSelection : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			queryParam:'name',
			listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.maxWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{courseCodeName}'  +
	                    '</div>';
	                }
	            }
        },{
        	xtype: 'customcombobox',
        	name: 'courseVarient',
        	itemId:'courseVarient_Id',
        	fieldLabel: getCourseTxCommonTranslation('HW_COURSE_VARIANT'),
        	store:'coursetransaction.sectionmanagement.CoruseVariantSectionStore',
        	displayField : 'code',
        	valueField : 'id',
        	disabled:true,
        	queryParam:'name',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			hideTrigger:false,
			minChars:3,
			forceSelection : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{courseCodeName}'  +
	                    '</div>';
	                }
	        }
        },{
				xtype: 'customcombobox',
				name : 'detailSequenceId',
	        	itemId:'detailSequenceItemId',
	        	fieldLabel : getExaminationTranslation('DETAILED_SQUENCE'),
	        	store:'examinationcenters.assessmentEvent.StudentAssessmentLevelListStore',
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				disabled:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = 'auto';
						setTimeout(function(){
							picker.el.dom.style.width='auto';
							picker.el.dom.style.minWidth = picker.up('combobox').getSize().width+'px';
						},10);
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}}
	    	},{
            	xtype: 'customcombobox',
            	itemId:'chooseSPAssessmentReportTemplate',
        		name: 'chooseSPAssessmentReportTemplateId',
        	    store:'setup.templatemapping.TemplateNameListFacultyByCode',//'examinationcenters.marksheet.MarksheetGenerationTemplate',
        		displayField:'code',
        		valueField:'id',
        		forceSelection:true,
        		typeAhead:true,
        		minChars:3,
        		hidden:true,
        		listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				}
    			},
        		fieldLabel:getExaminationTranslation('TEMPLATE')
            }]
    },{
	    xtype: 'fieldcontainer',
        width:'100%',
    	cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [ {
            xtype: 'button',
            itemId:'searchBtn',
            text: getCommonTranslation('SEARCH'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
			style:{marginLeft:'10px'},
            formBind:true
        },{
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId:'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
   }]
});