/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.studentPortal.SPStudentAssessmentReportGrid', {
	extend: 'Ext.tree.Panel',
	alias: 'widget.spstudentassessmentreportgrid',
	title: getExaminationTranslation('STUDENT_ASSESSMENT_REPORT'),
	border: true,
	cls: 'studentassessmentreportgrid no-tree-icon treeGrid',
	rootVisible: false,
	singleExpand: false,
	reserveScrollbar: true,
	height: window.innerHeight-150,
	useArrows: false,
	//disableSelection: true,
	frame:false,
	rowLines: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar : [{
		xtype : 'button',
		itemId : 'saveSPStudentAssessmentReportItemId',
		tooltip : getExaminationTranslation('SAVE'),
		text : getExaminationTranslation('SAVE'),
		ui: 'CustomBtnSubmit',
		cls: 'x-btn x-unselectable x-btn-CustomBtnSubmit-small x-noicon x-btn-noicon x-btn-CustomBtnSubmit-small-noicon',
		disabled: true
	},{
		xtype : 'button',
		itemId : 'submitSPStudentAssessmentReportItemId',
		tooltip : getExaminationTranslation('SUBMIT'),
		text : getExaminationTranslation('SUBMIT'),
		ui: 'CustomBtnSubmit',
		cls: 'x-btn x-unselectable x-btn-CustomBtnSubmit-small x-noicon x-btn-noicon x-btn-CustomBtnSubmit-small-noicon',
		disabled: true
	}, {
        xtype: 'displayfield',
        itemId: 'progressionStatusMessage',
        hidden:true,
        value:''
	    }, {
		xtype : 'button',
		itemId : 'exportSPStudentAssessmentGradeReportItemId',
		tooltip : getCommonTranslation('EXPORT_GRADE_BOOK'),
		text : getCommonTranslation('EXPORT_GRADE_BOOK'),
		disabled: true
	}, {
		xtype : 'button',
		itemId : 'exportSPStudentAssessmentReportItemId',
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
		disabled: true
	}],
	store: 'examinationcenters.studentportal.SPStudentAssessmentReportGridStore',
	columns: [{
		header:  "<input type='checkbox'>",
		width: 42,
		hideable : false,
		menuDisabled: true,
		resizable: false,
		sealed: true
	},{
		xtype: 'treecolumn',
		text: getCommonTranslation('COURSE_CODE_NAME'),
		flex: .33,
		dataIndex: 'treeNode'
	},{
		header:  getExaminationTranslation('EVALUATION_PLAN'),
		dataIndex: 'evaluationPlanName',
		flex:.1,
		hidden: true
	},{
		header:  getCommonTranslation('DATE_SUBMITTED'),
		dataIndex: 'conductedDate',
		flex:.15
	},{
		header:  getExaminationTranslation('RAW_SCORE'),
		dataIndex: 'eventMarksObtained',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				/*if(!isNullOrEmpty(rec.record.get('whetherExamAttended'))){
			if(rec.record.get('whetherExamAttended')==false){
				return "Ab";
			}else{
				return rec.record.get('eventMarksObtained');
			}

		}else{
			return  rec.record.get('eventMarksObtained');
		}*/
				if(isNullOrEmpty(val)){
					return '-';
				}
				if(!isNullOrEmpty(rec.record.get('whetherExamAttended'))){
					if(rec.record.get('whetherExamAttended')==false){
						return "Ab";
					}else{
						return Ext.util.Format.number(rec.record.get('eventMarksObtained'), '0.00');
					}

				}else{
					return Ext.util.Format.number(rec.record.get('eventMarksObtained'), '0.00');
				}
			}
			else {
				if(isNullOrEmpty(val)){
									return '-';
								}
								if(!isNullOrEmpty(rec.record.get('whetherExamAttended'))){
									if(rec.record.get('whetherExamAttended')==false){
										return "Ab";
									}else{
										return Ext.util.Format.number(rec.record.get('eventMarksObtained'), '0.00');
									}

								}else{
									return Ext.util.Format.number(rec.record.get('eventMarksObtained'), '0.00');
								}
			}
		}
	},{
		header:  getExaminationTranslation('MAX_RAW_SCORE'),
		dataIndex: 'eventTotalMarks',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return Ext.util.Format.number(val, '0.00');
				} else {
					return '-';
				}
			}
		}
	},{
		header:  getExaminationTranslation('SCORE_AS_A_PERCENTAGE'),
		dataIndex: 'eventPercentageObtained',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return Ext.util.Format.number(val, '0.00');
				} else {
					return '-';
				}
			}
		}
	//renderer  : Ext.util.Format.numberRenderer('0.00'),
	},{
		header:  getCommonTranslation('EFFECTIVE_MARKS'),
		dataIndex: 'effectiveMarks',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return Ext.util.Format.number(val, '0.00');
				} else {
					return '';
				}
			}
		}
	},{
		header:  getExaminationTranslation('PERCENTAGE_WEIGHT'),
		dataIndex: 'eventWeightage',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return Ext.util.Format.number(val, '0.00');
				} else {
					return '-';
				}
			}
		}
	//renderer  : Ext.util.Format.numberRenderer('0.00'),
	},{
		header:  getExaminationTranslation('WEIGHTED_SCORE_AS_A_PERCENTAGE'),
		dataIndex: 'weigtageOfObtainedPercentage',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return Ext.util.Format.number(val, '0.00');
				} else {
					return '-';
				}
			}
		}
	//renderer  : Ext.util.Format.numberRenderer('0.00'),
	},{
		header:  getExaminationTranslation('NUMERICAL_GRADE'),
		dataIndex: 'numericalGrade',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return val;
				} else {
					return '-';
				}
			}
		},
		hidden:  true
	},{
		header:  getExaminationTranslation('WEIGHTED_GRADE'),
		dataIndex: 'weightedGrade',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return val;
				} else {
					return '-';
				}
			}
		},
		hidden:  true
	},{
		header: getExaminationTranslation('ASSESSMENT_CODE'),
		dataIndex: 'eventGradeObtained',
		flex:.15,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(!isNullOrEmpty(val)){
					return val;
				} else {
					return '-';
				}
			}
		}
	}, {
		header:  getExaminationTranslation('TEACHER_COMMENT'),
		dataIndex: 'eventRemark',
		flex:.1
	},{
		header:  getExaminationTranslation('STUDENT_COMMENT'),
		dataIndex: 'studentEventRemark',
		flex:.1,
		renderer: function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(isNullOrEmpty(val)){
					val = "Add comment";
				}
				rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
				rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
				return "<a href='#'>"+val+"</a>";
			}
			return "";
		}
	},{
		header:  getExaminationTranslation('REPORT_STATUS'),
		dataIndex: 'whetherPublish',
		flex:.15,
		renderer: function(val,rec,record,rowIndex,colIndex,store,view){
			if(record.isLeaf()){
				if(isNullOrEmpty(val) || val==false){
					return "Not Published";
				}
				return "Published";
			}
			return "";
		}
	},{
		header:  getExaminationTranslation('PUBLISHED_DATE'),
		dataIndex: 'publishDate',
		flex:.15,
		hidden:  true
	},{
		header:  getExaminationTranslation('PROGRAM_NAME'),
		dataIndex: 'program',
		flex:.1,
		hidden:  true
	},{
		header:  getProgramandcourseTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		hidden:  true
	},{
		header:  getProgramandcourseTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		hidden:  true
	},{
		header:  getExaminationTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocationName',
		flex:.1,
		hidden:  true
	},{
		header:  getExaminationTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantName',
		flex:.1,
		hidden:  true
	}]
});