/**
 * @author Dharmendra.p
 */

Ext.define('Academia.view.studentPortal.attendancereport.StudentPortalProgramAttendanceGrid',{
	extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentportalprogramattendancegrid',
	title : getMegaMenuTranslation('SP_COURSE_ATTENDANCE'),
	border : true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns : [{
		header : getProgramandcourseTranslation('PROGRAM_NAME'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getProgramandcourseTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getProgramandcourseTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex:1
	},{
		header : getProgramandcourseTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex:1
	},{
		header : getProgramandcourseTranslation('TOTAL_RECORDS'),
		dataIndex : 'totalRecords',
		flex:1,
		renderer : function(value,records) {
			if(value>0){
				return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	},{
		header : getProgramandcourseTranslation('TOTAL_PRESENT'),
		dataIndex : 'presentRecords',
		flex:1,
		renderer : function(value,records) {
			if(value > 0){
				return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	}, {
		header : getProgramandcourseTranslation('TOTAL_PRESENT_PERCENT'),
		dataIndex : 'attendancePercentage',
		flex:1,
		renderer : function(value,records) {
			if(value > 0){
				return value+"%";
			}else{
				return "0%";
			}
		}
	}, {
		header : getProgramandcourseTranslation('TOTAL_ABSENT'),
		dataIndex : 'absentRecords',
		flex:1,
		renderer : function(value,records) {
			if(value > 0){
				return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	}, {
		header : getProgramandcourseTranslation('TOTAL_ABSENT_PERCENT'),
		dataIndex : 'absentPercentage',
		flex:1,
		renderer : function(value,records) {
			if(value > 0){
				return value+"%";
			}else{
				return "0%";
			}
		}
	}],
	initComponent : function() {
		var this$ = this;
		var store = this$.buildStudentStore();//(this$.personType == 'STUDENT') ? this$.buildStudentStore() : this$.buildFacultyStore();
		Ext.apply(this$,{
			store : store,
			dockedItems : [ {
				xtype : 'toolbar',
				dock : 'bottom',
				items : [ {
					xtype : 'custompagingtoolbar',
					plugins : [ 'pagesize' ],
					store : store,
					emptyMsg : getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo : true
				} ]
			} ]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStudentStore : function() {
		return Ext.create('Academia.store.personinfo.common.course.CourseAttendanceWCCPStore');
	}
});