/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.studentPortal.revaluation.RevalTransactionWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.revaltransactionwindow',
	title:getCommonTranslation('TRANSACTION_DETAILS'),
	frame: true,
	autoScroll:false,
	modal:true,
	method: 'POST',
	maxHeight:500,
	width: 330,
	height:260,
	padding:'10 10 10 10',
	resizable: false,
	items: [{
        xtype: 'form',
        itemId: 'revaltransactionwindowForm',
        standardSubmit: false,
        height : 400,
        plugins: "formlabelrequired",
        defaults: {
            labelAlign: 'top'
        },
        items: [{
            xtype: 'hidden',
            itemId: 'document_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'module'
        }, {
            xtype: 'hidden',
            name: 'entityId'
        }, {
            xtype: 'hidden',
            name: 'entityType'
        },{
        	xtype: 'fieldcontainer',
        	layout:'vbox',
        	defaults: {
        		labelAlign: 'top',
        		width: 256
        	},
        	items: [{
        		xtype: 'textfield',
        		itemId:'documentNameTextField',
        		allowBlank: false,
        		fieldLabel: getCommonTranslation('DOCMENT_NAME'),
        		ui: 'CustomBtnSubmit',
        		msgTarget: 'qtip'
        	}, {
        		xtype : 'filefield',
        		ui : 'CustomBtnThird',
        		fieldLabel : getCommonTranslation('UPLOAD_FILE'),
        		buttonText : getCommonTranslation('BROWSE_FILE'),
        		itemId : 'uploadFileField',
        		name : 'file',
        		allowBlank:false,
        		validateOnChange : true,
//        		listeners:{
//        			change: function(field, val) { 
//        				var fileName = /^.*\.(exe)$/i;
//        				if(fileName.test(val)){
//        					field.reset();
//        					showWarningMessage(getCommonTranslation('UPLOAD_DOCUMENT'),getCommonTranslation('CANNOT_UPLOAD_EXE_FILE'));
//        					return false;
//        				}
//        				value = val.replace('C:\\fakepath\\', '');
//        				field.setRawValue(value);
//        			}
//        		}
        	}],
        }, {
        	xtype: 'fieldcontainer',
        	layout:'hbox',
        	cls:'windowBtnPos',
        	items: [{
        		xtype: 'button',
        		itemId:'saveRevalTransactionBtn',
        		text: getCommonTranslation('SUBMIT'),
        		ui: 'CustomBtnSubmit',
        		scale: CONSTANTS.BUTTONSIZE,
                formBind: true
        	}, {
        		xtype: 'button',
        		text: getCommonTranslation('CANCEL'),
        		itemId:'cancelBtn',
        		ui: 'CustomBtnCancel',
        		scale: CONSTANTS.BUTTONSIZE
        	}]
        }]
	}]
});