/**
 * @author Bhanu Pratap Singh
 */
Ext.define('Academia.view.studentPortal.revaluation.RevaluationStudentFilter', {
	extend: 'Ext.form.FormPanel',
    alias: 'widget.revaluationstudentfilter',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
	collapsible: true,
	border:true,
    modal: true,
    method: 'POST',
    standardSubmit : false,
    plugins : "formlabelrequired",
    items: [{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
			xtype:'hidden',
			name:'isRevalFeeApplicable',
			itemId : 'isRevalFeeApplicable',
		},{
			xtype:'hidden',
			name:'isReviewFeeApplicable',
			itemId : 'isReviewFeeApplicable',
		},{
			xtype:'hidden',
			name:'isChallengeFeeApplicable',
			itemId : 'isChallengeFeeApplicable',
		},{
			xtype:'hidden',
			name:'revalFeePlanRuleStageId',
			itemId : 'revalFeePlanRuleStageId',
		},{
			xtype:'hidden',
			name:'reviewFeePlanRuleStageId',
			itemId : 'reviewFeePlanRuleStageId',
		},{
			xtype:'hidden',
			name:'challengeFeePlanRuleStageId',
			itemId : 'challengeFeePlanRuleStageId',
		},{
			xtype:'hidden',
			name:'revalFeeAmount',
			itemId : 'revalFeeAmount',
		},{
			xtype:'hidden',
			name:'reviewFeeAmount',
			itemId : 'reviewFeeAmount',
		},{
			xtype:'hidden',
			name:'challengeFeeAmount',
			itemId : 'challengeFeeAmount',
		},{
			 xtype: 'customcombobox',
             name: 'attendanceProgram',
             itemId: 'attendanceProgramId',
             fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
             store:'servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer',
             valueField: 'programId',
             displayField: 'programCodeValue',         
//             translationKey: 'PROGRAM',
             typeAhead:true,
         	 forceSelection:true,
			queryParam:'name',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
		},{
			xtype: 'customcombobox',
            name: 'studentBatch',
            itemId: 'batchCombo',
          //  displayField: 'batchName',
//            translationKey: 'BATCH',
            store: Ext.create('Academia.store.student.studentprofile.StudentProgramStore'),
            displayField : 'value',
        	valueField : 'id',
            queryMode: 'local',
            disabled : true,
            fieldLabel: getCommonTranslation('BATCH'),
			forceSelection: true
			
		},{
			xtype: 'customcombobox',
			name: 'period',
			itemId : 'periodId',
			fieldLabel: getCommonTranslation('PERIOD'),
//			translationKey: 'PERIOD',
			store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
        	displayField : 'value',
        	valueField : 'id',
			disabled : true,
			allowBlank:false,
			forceSelection: true
		}]
    },{
	    xtype: 'fieldcontainer',
        width:'100%',
    	cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [ {
            xtype: 'button',
            itemId:'searchBtn',
            text: getCommonTranslation('SEARCH'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
        },{
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId:'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
   }]
});