/**
 * @author Amit Gupta
 */
Ext.define('Academia.view.studentTransferCreditRequest.StudentTransferCreditFilter', {
	//extend: 'Ext.form.Panel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.studenttransfercreditfilter',
    //autoScroll: true,
    frame: false,
    //layout: 'vbox',
    method: 'POST',
    cls:'customSearchPanel',
    standardSubmit: false,
    viewConfig: {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
    			fieldLabel: getCommonTranslation('ADMISSION_STUDENT_NAME_TRANSFER'),
                name: 'admissionId',
                itemId:'admissionId',
                store: 'student.StudentTransferCreditRequest.STDTrasferAdmissionStudentNameStore',
                displayField: 'value',
                valueField: 'id',
                width: 536,
                typeAhead : false,
                forceSelection:true,
                hideTrigger:false,
                queryMode: 'remote',
                queryParam: 'qry',
        	    triggerAction: 'all',
                minChars:3,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                    '{value}'  +
    	                    '</div>';
    	                }
    	            }
            }]
        	},{
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: {
                    type: 'hbox'
                },
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                items: [{
        			xtype: 'customcombobox',
        			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'), //Program
        			name: 'PROGRAM',
        			itemId: 'programId',
        			autoload: false,
        			store: 'student.StudentTransferCreditRequest.STDTrasferProgramStore',
        			valueField: 'id',
        			displayField: 'valueCode',
        			queryParam:'qry',
                    forceSelection:true,
                    hideTrigger:false,
                    triggerAction: 'all',
                    minChars:3,
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                    listConfig: {
        				  listeners: {
        						beforeshow: function(picker) {
        							picker.minWidth = picker.up('combobox').getSize().width;
        						}
        					},
        	                loadingText: getCommonTranslation('SEARCHING'),
        	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        	                getInnerTpl: function() {
        	                    return '<div class="search-item">' +
        	                    '{code} / {value}'+ 
        	                    '</div>';
        	                }
        	            }
        		},{
        			xtype: 'customcombobox',
        			fieldLabel: getAdmissionTranslation('BATCH'),   //Batch
        			name: 'BATCH',
        			itemId: 'batchId',
        			editable: true,
        			autoload: false,
        			typeAhead:false,
        			disabled:true,
        			queryParam:'All',
        			valueField: 'id',
        			displayField: 'value',
        		     listConfig: {
        					listeners: {
        						beforeshow: function(picker) {
        							picker.minWidth = picker.up('combobox').getSize().width;
        						}
        					},
        					loadingText: getCommonTranslation('SEARCHING'),
        					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        					getInnerTpl: function() {
        						return '<div class="search-item">' +
        						'{code} / {value}'+ 
        						'</div>';
        					}
        			},
                    listeners: {
                        render: function(combo) {
                            var store = Ext.create('Academia.store.student.StudentTransferCreditRequest.STDTrasferBatchStore');
                            combo.bindStore(store);
                        }
                    }
        		}]
            },{
            xtype: 'fieldcontainer',
            width: 'auto',
    		layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'quickSearchId',
                buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            },{
    			xtype: 'button',
    			itemId: 'resetBtn',
    			text: getCommonTranslation('RESET'),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE
    		}]
        }]

});