/**
 * @author Amit Gupta
 */
//var gridStore = Ext.create('Academia.store.studentTransferCreditRequest.StudentTransferCreditStore');
var StudentTransferCreditGridStore = Ext.create('Academia.store.student.StudentTransferCreditRequest.StudentTransferCreditMainGridStore');
Ext.define('Academia.view.studentTransferCreditRequest.StudentTransferCreditGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studenttransfercreditgrid',
	store: StudentTransferCreditGridStore,
	title:getCommonTranslation('ALL_REQUEST'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : StudentTransferCreditGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	columns: [{
		header: getCommonTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		sortable: true,
		flex: .2,
		renderer : function(value){
			if( !isNullOrEmpty(value) && value != 0 ){
				return  '<a href="#">'+value+'</a>';
			} else {
				return  value;
			}
		}
	},{
		header: getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('TYPE_OF_TRANSFER_CREDIT'),
		dataIndex: 'examTransferCreditType',
		sortable: true,
		flex: .2,
		renderer:function(value) {
			return getCommonTranslation(value);
		}
	},{
		header: getCommonTranslation('STATUS'),
		dataIndex: 'status',
		sortable: true,
		flex: .2,
		renderer:function(value) {
			return getCommonTranslation(value);
		}
	},{
		header: getCommonTranslation('COMPLETION_STATUS'),
		dataIndex: 'completionStatus',
		sortable: true,
		flex: .2,
		renderer:function(value) {
			return getCommonTranslation(value);
		}
	},{
		header: getCommonTranslation('REQUEST_DATE'),
		dataIndex: 'requestedDate',
		sortable: true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header: getCommonTranslation('APPROVED_REJECTED_BY'),
		dataIndex: 'statusUpdateBy',
		sortable: true,
		flex: .2
	},{
		header: getCommonTranslation('APPROVAL_REJECTION_DATE'),
		dataIndex: 'statusUpdateDate',
		sortable: true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}]
});