/**
 * @author Shivam Joshi
 */
var studentJourneySetupStore = Ext.create('Academia.store.student.studentJourney.StudentJourneySetupStore');
Ext.define('Academia.view.studentjourneysetup.StudentJourneySetupGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentjourneysetupgrid',
	store : studentJourneySetupStore,
	border: true,
	title: getProgramandcourseTranslation('ACADEMIC_TERM_CONFIGURATION'),
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			itemId : 'custompagingtoolbarId',
			plugins:['pagesize'],
			store : studentJourneySetupStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	tbar : [ {
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH	
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns : [{
		header : getAdmissionTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 0.2
	},{
		header : getProgramandcourseTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 0.2

	},{
		header : getProgramandcourseTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 0.2,

	}, {
		header : getCommonTranslation('ACADEMIC_TERM'),
		dataIndex : 'academicTermSeq',
		flex : 0.2,
	}]

});
