Ext.define('Academia.view.sunsuccess.SunSuccessForm', {
	extend: 'Ext.form.Panel',
    alias: 'widget.sunsuccessform',
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	standardSubmit: false,
    items:[{
    	xtype:'fieldcontainer',
    	defaults:{
    		labelAlign :'top',
    	},
		layout:'hbox',
    	items:[{
        	xtype: 'customcombobox',
        	fieldLabel : getCommonTranslation('SUN_BI_SUCCESSFLAGS'),
        	width : 400,
        	itemId:'flagnameId',
        	displayField: 'displayValueFld',
        	valueField: 'id',
        	editable:true,
        	forceSelection: true,
        	store:Ext.create('Academia.store.sunsuccess.SunSuccessStore'),
			minChars:3,
			queryParam:'name',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
        	
        },{
        	xtype:'customcombobox',
        	fieldLabel : getCommonTranslation('STATUS'),
        	name:'status',
        	itemId:'statusId',
        	displayField:'name',
    		valueField:'value',
    		value: true,
    		forceSelection: true,
    		editable: false,
    		store: {
        		fields : ['id', 'name','value'],
        		data: [
        			{ id:'ACTIVE', name:'Active', value:true },            
        			{ id:'INACTIVE',name:'Inactive', value:false}
        		]
    		}
        }]	
    },{
    	xtype:'fieldcontainer',
    	cls : 'windowBtnPos',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items:[{
        	xtype : 'button',
        	text  : getCommonTranslation('SEARCH'),
        	itemId : 'searchButtonId',
			formBind: true,
			//buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			formBind : true,
        },{
        	xtype : 'button',
        	text  : getCommonTranslation('RESET'),
        	itemId: 'resetId',
			//buttonAlign : 'left',
			ui : 'CustomBtnCancel',
        }]
    
}]
  
	
});