Ext.define('Academia.view.sunsuccess.SunSuccessMapFlagsFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.sunsuccessmapflagsfilter',
    autoScroll: false,
    frame: false,
    //layout: 'vbox',
    method: 'POST',
    cls:'customSearchPanel',
    standardSubmit: false,
    viewConfig: {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'multiselectcombofield',
    			fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
                name: 'academyLocationCombo',
                itemId:'academyLocationCombo',
                store:  Ext.create('Academia.store.common.AccesibleAcademyLocationNameSeparated'),
                displayField: 'value',
                valueField: 'id',
                typeAhead : false,
                forceSelection:true,
                hideTrigger:false,
                queryMode: 'remote',
                queryParam: 'qry',
        	    triggerAction: 'all',
        	    cls: 'manageFeePlanMultiselect',
	              listConfig: {
	    				  listeners: {
	    						beforeshow: function(picker) {
	    							picker.minWidth = picker.up('combobox').getSize().width;
	    						}
	    					},
	    	                loadingText: getCommonTranslation('SEARCHING'),
	    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    	                getInnerTpl: function() {
	    	                    return '<div class="search-item">' +
	    	                    '{value}'  +
	    	                    '</div>';
	    	                }
	    	  }
            },{  
            	  xtype: 'multiselectcombofield', 
            	   fieldLabel: getCommonTranslation('PROGRAM'),
            	    name: 'program',
            	    itemId: 'program',
            	    store: Ext.create('Academia.store.facilitiesresources.resourcemaster.ProgramListGridStore'),
            	    displayField: 'value',
            	    valueField: 'id',
            	    typeAhead: false,
            	    forceSelection: true,  
            	    hideTrigger: false,
            	    queryMode: 'remote', 
            	   queryParam: 'qry', 
            	   triggerAction: 'all',
            	 cls: 'manageFeePlanMultiselect',
            	  listConfig: {    
            	    listeners: { 
            	           beforeshow: function(picker) {  
            	              picker.minWidth = picker.up('combobox').getSize().width;   
            	         }        },        loadingText: getCommonTranslation('SEARCHING'),  
            	      emptyText: getCommonTranslation('NO_RECORDS_FOUND'),   
            	     getInnerTpl: function() {      
            	      return '<div class="search-item">' + '{value}' + '</div>';    
            	    }}
            	}, {  
            	   xtype: 'multiselectcombofield', 
               	   fieldLabel: getCommonTranslation('BATCH'),
               	    name: 'batch',
               	    itemId: 'batch',
               	   	store: Ext.create('Academia.store.facilitiesresources.resourcebooking.AllBatchesStore'),
               	    displayField: 'value',
               	    valueField: 'id',
               	    typeAhead: false,
               	    forceSelection: true,  
               	    hideTrigger: false,
               	    queryMode: 'remote', 
               	   queryParam: 'qry', 
               	   triggerAction: 'all',
               	 disabled:true,
               	cls: 'manageFeePlanMultiselect',
               	   listConfig: {    
               	    listeners: { 
               	           beforeshow: function(picker) {  
               	              picker.minWidth = picker.up('combobox').getSize().width;   
               	         }        },        loadingText: getCommonTranslation('SEARCHING'),  
               	      emptyText: getCommonTranslation('NO_RECORDS_FOUND'),   
               	     getInnerTpl: function() {      
               	      return '<div class="search-item">' +'{value}' +'</div>';    
               	    }
               	    }
               	}]
            	},{

                xtype: 'fieldcontainer',
                layout: 'hbox',
                defaults: {
                    width: 256,
                    labelAlign: 'top'
                },
                items: [{
                    xtype: 'multiselectcombofield',
                    name: 'businessRuleName',
                    itemId: 'businessRuleName',
                    fieldLabel: getCommonTranslation('BUSINESS_RULE_ID_NAME'),
                    valueField: 'id',
        			displayField: 'displayValueFld',
        			forceSelection:true,
        			store:  Ext.create('Academia.store.sunsuccess.BusinessRuleNameStore'),
        			autoloadStore: false,
        			//editable:false,
        			typeAhead: false,
                   	 forceSelection: true,  
                   	    hideTrigger: false,
                   	    queryMode: 'remote', 
                   	   queryParam: 'qry', 
                   	   triggerAction: 'all', 
          			cls:'manageFeePlanMultiselect',
          			 listConfig: {    
                        	    listeners: { 
                        	           beforeshow: function(picker) {  
                        	              picker.minWidth = picker.up('combobox').getSize().width;   
                        	         }        },        loadingText: getCommonTranslation('SEARCHING'),  
                        	      emptyText: getCommonTranslation('NO_RECORDS_FOUND'),   
                        	     getInnerTpl: function() {      
                        	      return '<div class="search-item">' +'{value}' +'</div>';    
                        	    }
                        	    }
                },{
        			xtype: 'customcombobox',
        			fieldLabel: getCommonTranslation('SUN_BI_SUCCESSFLAGS'),   //Batch
        			name: 'flagId',
        			itemId: 'flagId',
        			autoload: false,
        			store: Ext.create('Academia.store.sunsuccess.SunSuccessFlagIDStore'),
        			//disabled:true,
        			valueField: 'id',
        			displayField: 'displayValueFld',
        			forceSelection:true,
  				  listConfig: {
  					  listeners: {
  							beforeshow: function(picker) {
  								picker.minWidth = picker.up('combobox').getSize().width;
  							}
  						},
  		                loadingText: getCommonTranslation('SEARCHING'),
  		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  		                getInnerTpl: function() {
  		                    return '<div class="search-item">' +
  		                    '{code} / {value}'  +
  		                    '</div>';
  		                }
  		            }
        		},{
                	xtype: 'customcombobox',
        			name: 'flagColor',
        			itemId:'flagColor',
        			fieldLabel: getCommonTranslation('FLAG_COLORR'),
        			valueField: 'id',
        			displayField: 'value',
        			store: Ext.create('Academia.store.sunsuccess.SunSuccessStudendFlagColorStore'),
          			//width: 698,
//        			disabled:true,
        			editable:false,
          			cls:'multiBrandCampusCls',
          			typeAhead: true,
                    forceSelection: true,
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{code}' +
                            '</div>';
                    }
                }]
            	
        	},{
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: {
                    type: 'hbox'
                },
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                items: [{
        			xtype: 'customcombobox',
        			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'), //Program
        			name: 'studentID',
        			itemId: 'studentID',
        			autoload: false,
        			store: Ext.create('Academia.store.sunsuccess.SunSuccessStudendIDStore'),
        			valueField: 'secondId',
        			displayField: 'displayValueFld',
        			minChars:3,
    				typeAhead:false,
    	            //hideTrigger:true,
    				disabled:true,
    	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    				forceSelection:true,
    				  listConfig: {
    					  listeners: {
    							beforeshow: function(picker) {
    								picker.minWidth = picker.up('combobox').getSize().width;
    							}
    						},
    		                loadingText: getCommonTranslation('SEARCHING'),
    		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    		                getInnerTpl: function() {
    		                    return '<div class="search-item">' +
    		                    '{code} / {printName}'  +
    		                    '</div>';
    		                }
    		            }
        		},{
                    xtype: 'customcombobox',
                    name: 'publishStatus',
                    itemId: 'publishStatus',
                    fieldLabel: getCommonTranslation('PUBLISH_STATUSS'),
                    valueField: 'id',
        			displayField: 'value',
        			store: Ext.create('Academia.store.sunsuccess.PublishStatusGridStore'),
          			//width: 698,
//        			isFirstTimeLoad:false,
        			disabled:false,
        			editable:false,
//          			cls:'multiBrandCampusCls',
          			typeAhead: true,
          			//forceSelection: true,
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{code}' +
                            '</div>';
                    }
                },{
        			xtype: 'customcombobox',
        			fieldLabel: getCommonTranslation('AGGREGATIONS'), //Seat Type
        			name: 'aggregations',
        			itemId: 'aggregations',
        			autoload: false,
        			store:Ext.create('Academia.store.sunsuccess.SunSuccessAggregationsStore'),
        			//disabled:true,
        			valueField: 'id',
        			displayField: 'value',
        			forceSelection: true,
        			queryMode: 'local',
        			listConfig: {
        				listeners: { 
                    		beforeshow: function(picker) {  
                    	    	picker.minWidth = picker.up('combobox').getSize().width;
                    			picker.maxWidth = picker.up('combobox').getSize().width;
                    	    }
        				},
        				loadingText: getCommonTranslation('SEARCHING'),  
                    	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),   
                    	getInnerTpl: function() {      
                    		return '<div class="search-item">' +'{value}' +'</div>';    
                    	}
                    },
                	listeners: {
                		afterrender: function(cmp) {
                			cmp.getStore().load();
                		}
                	}
        		}]
            },{
            xtype: 'fieldcontainer',
            width: 'auto',
    		layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'quickSearchId',
                //buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                margin: '0 44 0 0'
            },{
    			xtype: 'button',
    			itemId: 'resetBtn',
    			text: getCommonTranslation('RESET'),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE
    		}]
        }]

   // }]
});