/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.sunsuccess.businessrules.BusinessRuleApplyToCourseAddForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.businessruleapplytocourseaddform',
	border: false,
	frame: false,
	cls:'customSearchPanel',
	plugins : "formlabelrequired",
	items: [{
		xtype: 'fieldset',
		width: '100%',
		style: {
			'margin-top': '-8px !important',
			'padding': '10px 10px 10px 3px !important'
		},
		items: [{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'academicTerm',
				fieldLabel:getAdmissionTranslation('ACADEMIC_TERM'),
				itemId: 'addCourseAcademicTermItemId',
				forceSelection : true,
				allowBlank: false,
				store:Ext.create('Academia.store.sunsuccess.BusinessRuleAcadmictermStore'),
				displayField: 'value',
				valueField: 'id',
				editable: false
			}, {
				xtype: 'multiselectcombofield',
				name: 'academicname',
				fieldLabel: getExaminationTranslation('ACADEMY_LOCATION'),
				itemId: 'addCourseAcademicNameId',
				store:'sunsuccess.BusinessRuleAcademyLocationStore',
				width : 400,
				forceSelection : true,
				allowBlank: false,
				displayField: 'value',
				valueField: 'id',
				autoloadStore: false
			}]
		}, {
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'multiselectcombofield',
				fieldLabel: getServiceRequestTranslation('DEPARTMENT'),
				name: 'departmentname',
				itemId: 'addCourseDepartmentNameId',
				displayField: 'value',
				valueField: 'id',
				maxLength:100000,
				allowBlank: false,
				disabled: true,
				forceSelection : true,
				store: Ext.create('Academia.store.sunsuccess.BusinessRuleDepartmentStore')
			}, {
				xtype: 'multiselectcombofield',
				name: 'subdepartmentname',
				fieldLabel:getServiceRequestTranslation('SUB_DEPARTMENT'),
				itemId: 'addCourseSubDepartmentNameId',
				displayField: 'value',
				valueField: 'id',
				width : 400,
				maxLength:100,
				forceSelection : true,
				store: Ext.create('Academia.store.sunsuccess.BusinessRuleSubDepartmentStore'),
				minChars: 3,
				queryParam:'organizationId',
				multiSelect: true,
				disabled: true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				},
				editable: false
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text : getCommonTranslation('SEARCH'),
			itemId: 'addCourseSearchButtonId',
			formBind: true,
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit'
		},{
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId: 'addCourseResetBtnId',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel'
		}]
	}]
});