/**
 * 
 */
Ext.define('Academia.view.sunsuccess.businessrules.BusinessRuleForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.businessruleform',
	title: getExaminationTranslation('ADD_BUSINESS_RULE'),
	border: true,
	//bodyPadding: 8,
	frame: true,
	style: {
		marginLeft: CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	method: 'POST',
	plugins : "formlabelrequired",
	cls: 'x-form-fixed-footer-parent',
	items: [{
		xtype: 'fieldset',
		title: getCommonTranslation('BASIC_DETAILS'),
		//layout: 'vbox',
		frame: true,
		collapsible: true,
		width: '100%',
		cls: 'fieldset-without-legend-padding',
		items: [{
			xtype: 'textfield',
			hidden: true,
			name: 'id'
		}, {
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'textfield',
				name: 'codeValue',
				fieldLabel: getExaminationTranslation('BUSINESS_RULE_ID'),
				itemId: 'businessRuleId',
				readOnly: true,
				allowOnlyWhitespace: false
			}, {
				xtype: 'textfield',
				name: 'nameValue',
				fieldLabel: getExaminationTranslation('BUSINESS_RULE_NAME'),
				itemId: 'businessRuleName',
				width : 400,
				maxLength:100,
				maskRe:/[A-Za-z0-9\s]/,
				allowBlank: false,
				allowOnlyWhitespace: false
			}]
		}, {
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('STATUS'),
				name: 'businessRuleStatus',
				itemId: 'statusId',
				displayField: 'name',
				valueField: 'value',
				value: true,
				allowBlank: false,
				store: {
					fields: ['id', 'name', 'value'],
					data: [
						{ id: 'ACTIVE', name: 'Active', value: true },            
						{ id: 'INACTIVE', name: 'Inactive', value: false }
						]
				},
				editable: false
			}, {
				xtype: 'customcombobox',
				name: 'roleId',
				fieldLabel: getCommonTranslation('LIST_OF_ROLES'),
				itemId: 'listOfRolesItemId',
				displayField: 'code',
				valueField: 'id',
				store: Ext.create('Academia.store.sunsuccess.SunSuccessNewFlagRolesStore'),
				minChars: 3,
				queryParam: 'name',
				multiSelect: false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				},
				editable: false
			}]
		}]
	}, {
		xtype: 'panel',
		title: getExaminationTranslation('BUSINESS_RULES_CONDITIONS'),
		margin: '33 0 16 0',
		//layout: 'vbox',
		frame: false,
		collapsible: true,
		width: '100%',
		layout: 'fit',
		items: [{
			xtype: 'fieldcontainer',
			itemId: 'businessRuleConditionContainer'//,
			/*items: [{
				xtype: 'businessrulecondition'
			}]*/
		}]
	}, {
		xtype: 'fieldcontainer',
		cls: 'windowBtnPos form-fixed-footer',
		items: [{
			xtype: 'button',
			text : getCommonTranslation('SAVE'),
			itemId: 'saveButtonId',
			formBind: true,
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit'
		},{
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId: 'resetBtnId',
			//buttonAlign: 'left',
			ui: 'CustomBtnCancel'
		}]
	}]
});