Ext.define('Academia.view.sunsuccess.businessrules.BusinessRulesFilter', {
	extend : 'Ext.form.Panel',
	alias : 'widget.businessrulesfilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	standardSubmit: false,
	items:[{
		xtype:'fieldcontainer',
		defaults:{
			labelAlign :'top',
		},
		layout:'hbox',
		items:[{
			xtype: 'customcombobox',
			fieldLabel: getExaminationTranslation('BUSINESS_RULES_ID_OR_NAME'),
			width : 400,
			name: 'businessRuleId',
			itemId: 'businessRuleId',
			autoload: false,
			store: Ext.create('Academia.store.sunsuccess.BusinessRulesComboStore'),
			valueField: 'id',
			displayField: 'displayValueFld',
			minChars:3,
			typeAhead:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            queryParam: 'name',
			forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {firstName}'  +
	                    '</div>';
	                }
	            }
		}, {
        	xtype:'customcombobox',
        	fieldLabel : getCommonTranslation('STATUS'),
        	name:'status',
        	itemId:'statusId',
        	displayField:'name',
    		valueField:'value',
    		value: true,
    		editable: false,
    		store: {
        		fields : ['id', 'name','value'],
        		data: [
        			{ id:'ACTIVE', name:'Active', value:true },            
        			{ id:'INACTIVE',name:'Inactive', value:false}
        		]
    		}
        }]	
	},{
		xtype:'fieldcontainer',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items:[{
			xtype : 'button',
			text  : getCommonTranslation('SEARCH'),
			itemId : 'searchButtonId',
			formBind: true,
			//buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			formBind : true
		},{
			xtype : 'button',
			text  : getCommonTranslation('RESET'),
			itemId: 'resetBtnId',
			//buttonAlign : 'left',
			ui : 'CustomBtnCancel'
		}]
	}]
});