/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.sunsuccess.businessrules.MappedFlagWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.mappedflagwindow',
	modal : true,
	resizable:true,
	//autoScroll: true,
	overflowY: 'auto',
	overflowX: 'hidden',
	maxHeight: window.innerHeight - 250,
	width: 860,
	cls: 'mappedflagwindowCls',
	title:getExaminationTranslation('FLAG_CODE_OR_NAME'),
	layout: 'vbox',
	defaults: {
		width: '100%'
	},
	items: [{
		xtype: 'grid',
		//width: 855,
		frame: false,
		border:true,
		store: 'sunsuccess.BusinessRuleMappedFlagStore',
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		columns: [{
			header: getExaminationTranslation('FLAG_CODE_OR_NAME'),
			dataIndex: 'value',
			sortable: true,
			flex: 1
		}],
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			    store : 'sunsuccess.BusinessRuleMappedFlagStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
			}]
		}]
	}]
});