Ext.define('Academia.view.survey.createSurvey.CreateSurveyFilter', {
	extend: 'Ext.form.FormPanel',
    alias: 'widget.createsurveyfilter',
    plugins : "formlabelrequired",
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
    items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'customcombobox',
            itemId: 'activeSurveyListComboItemId',
            name:'activeSurveyListCombo',
            store: 'survey.ActiveSurveyListStore',	    
            valueField:'sid',
            displayField:'surveyls_title',
            editable:false,
            readOnly: false,
			fieldLabel: getCommonTranslation('LIST_OF_ACTIVE_SURVEY'),
			allowBlank: false,
			matchFieldWidth:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
			}
        }]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});