Ext.define('Academia.view.survey.sendSurvey.AdHocSurveyReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.adhocsurveyreportgrid',
	title: getAdmissionTranslation('SEARCH_RESULT'),
	border: true,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	tbar: [{
		xtype: 'button',
		text:getCommonTranslation('EXPORT_REPORT'),
		itemId:'exportAdHocReport',
		tooltip :getCommonTranslation('EXPORT_REPORT'),
		disabled:true
	}],
	columns: [{
		header: getCommonTranslation('SURVEY_ID'),
		dataIndex: 'sid',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('SURVEY_NAME'),
		dataIndex: 'surveyls_title',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('START_DATE'),
		dataIndex: 'startdate',
		flex:.3,
		sortable: true
	}, {
		header: getCommonTranslation('END_DATE'),
		dataIndex: 'expires',
		flex:.3,
		sortable: true
	},{
		header: getCBTranslation('survey_whetherAnonymous'),
		dataIndex: 'isAnonymized',
		flex:.3,
		sortable: true,
		renderer : function(value){
			if(!isNullOrEmpty(value) && (value=="true" || value==true)){
				return  getCommonTranslation('YES');
			}else{
				return getCommonTranslation('NO');
			}
		}
	},{
		header: getCommonTranslation('STATUS'),
		dataIndex: 'active',
		flex:.3,
		sortable: true,
		renderer : function(value){
			if(value == "Y"){
				return getCommonTranslation('ACTIVE');
			}else{
				return getCommonTranslation('INACTIVE');
			}
		}
	},{
		header: getCommonTranslation('NO_OF_QUESTIONS'),
		dataIndex: 'noOfQuestions',
		flex:.3,
		sortable: true,
		renderer:function(value,rec){
			if(!isNullOrEmpty(value)){
				return '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header: getCommonTranslation('PARTICIPATION'),
		dataIndex: 'participationPercentage',
		flex:.3,
		sortable: true,
		renderer : function(value){
			return value+" %";
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$, false);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.survey.AdHocSurveyReportGridStore');
	}
});