Ext.define('Academia.view.survey.sendSurvey.SendSurveyFilter', {
	extend: 'Ext.form.FormPanel',
    alias: 'widget.sendsurveyfilter',
    plugins : "formlabelrequired",
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
    items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			name : 'academyLocation',
			itemId:'academyLocation',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.AcademyLocationsByAdmissionStore'),
			valueField : 'id',
			displayField : 'value',
			width: 536,
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			editable:false,
			allowBlank: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),	
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			typeAhead : false,
			forceSelection : true,
			store : Ext.create('Academia.store.common.AcademicTermStore'),
			hidden : false,
			width: 256,
			editable : false,
			allowBlank: false
		}]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'programId',
			itemId: 'programId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store:Ext.create('Academia.store.feeandpayment.ALProgramSearchCombo'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
			forceSelection:true ,
		    typeAhead:false,
		    disabled: true,
		    allowBlank: true,
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			fieldLabel: getCourseTxCommonTranslation('BATCH'),
			itemId:'batchId',
			store:Ext.create('Academia.store.examconcession.ExamConcessionBatchStore'),
			displayField: 'value',
			valueField: 'id',
			disabled : true,
			typeAhead:false,
			forceSelection:true,
			editable : false,
			allowBlank: true
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'periodId',
			fieldLabel: getCourseTxCommonTranslation('PERIOD'),
			store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCourseParameterizationPeriodStore'),
			displayField: 'value',
			valueField: 'id',
			disabled : true,
			allowBlank: true,
			typeAhead:true,
			forceSelection:true,
			editable : false 
		}]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'multiselectcombofield',
			name : 'courseId',
			itemId : 'courseId',
			fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
			store : Ext.create('Academia.store.programCourseDashboard.ParameterisedCoursesStore'),
			displayField : 'value',
			valueField : 'id',
			forceSelection : true,
		    typeAhead:false,
		    editable: false,
		    triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			cls:'commonAutoHeightMultiselectField sendSurveyCourseMultiselect',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('SELECT_DROPDOWN_VALUE'),
			allowBlank: true,
			disabled: true,
			addAllSelector: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							try {
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
							}
							catch(err) {
								console.log(err);
							}
				        });
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype : 'multiselectcombofield',
			name : 'courseVariantId',
			itemId : 'courseVariantId',
			fieldLabel : getCommonTranslation('COURSE_VARIANT'),
			store : Ext.create('Academia.store.course.coursevariants.CourseVariantForSurvey'),
			displayField : 'courseVariantCode',
			valueField : 'id',
			disabled : true,
			typeAhead : false,
			forceSelection : true,
			editable: false,
		    triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			cls:'commonAutoHeightMultiselectField sendSurveyCourseMultiselect',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('SELECT_DROPDOWN_VALUE'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							try {
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
							}
							catch(err) {
								console.log(err);
							}
				        });
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'facultyName',
			itemId: 'facultyItemId',
			fieldLabel:getCommonTranslation('FACULTY_CODE_NAME'),
			store : Ext.create('Academia.store.coursetransaction.facultytopicassignment.ParameterizedFaculties'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			disabled:true,
			typeAhead : true,
			forceSelection : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		}]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items:[{
			xtype : 'multiselectcombofield',
			name : 'surveyTemplate',
			itemId : 'surveyTemplateItemId',
			fieldLabel : getCommonTranslation('SURVEY_TEMPLATE'),
			store : Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionGroupCourseVariantStore'),
			displayField : 'value',
			valueField : 'id',
			disabled : false,
			typeAhead : false,
			forceSelection : true,
			editable: false,
		    triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			cls:'commonAutoHeightMultiselectField resetPasswordMultiselect',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('SELECT_DROPDOWN_VALUE'),
			disabled: true,
			hidden: true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							try {
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
							}
							catch(err) {
								console.log(err);
							}
				        });
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'surveyName',
			itemId: 'surveyNameItemId',
			fieldLabel:getCommonTranslation('SURVEY_NAME'),
			store: Ext.create('Academia.store.survey.SpecificSurveyListStore'),	    
            valueField:'surveyId',
            displayField:'surveyName',
			width: 256,
			disabled:false,
			typeAhead : true,
			forceSelection : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			matchFieldWidth:true,
			hidden: true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
			},
			listeners:{
				afterrender: function(combo) {
		            // Ensure that the store is loaded and ready
		            var store = combo.getStore();
		            
		            // Check if the store has not been loaded yet
		            if (store) {
		                store.on('beforeload', function(store) {
		                    store.getProxy().extraParams = {
		                        isCourse: true // Pass additional params before loading
		                    };
		                });
		            }
		        }
			}
		},{
			xtype: 'customcombobox',
			name: 'whetherAnonymousCourseLevel',
			itemId: 'whetherAnonymousCourseLevelItemId',
			fieldLabel: getCBTranslation('survey_whetherAnonymous'),
			store: Ext.create('Ext.data.Store', {
		        fields: ['code', 'value'],
		        data: [
		            { code: 'Y', value: getCommonTranslation("YES") },  // For Anonymous
		            { code: 'N', value: getCommonTranslation("NO") }    // For Non-Anonymous
		        ]
		    }),	    
            valueField:'code',
            displayField:'value',
			width: 256,
			disabled:false,
			typeAhead : false,
			forceSelection : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			editable:false,
			hidden: true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				}
			}
		}]
	}, {
		xtype:'fieldcontainer',
		layout: 'hbox',
		style: {
			'margin-left': '-32px !important;'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			ui: 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});