Ext.define('Academia.view.survey.sendSurvey.SendSurveyStructure', {
	extend: 'Ext.panel.Panel',
    alias: 'widget.sendsurveystructure',
    frame: false,
	autoScroll: true,
	defaults:{
		width: '100%',
		margin: '20 20 20 20'
	},
    items:[{
    	xtype: 'form',
    	itemId: 'surveyTypeMainFilterForm',
    	plugins : "formlabelrequired",
        autoScroll: false,
        //cls:'customSearchPanel',
    	frame: false,
    	method: 'POST',
    	standardSubmit: false,
        items: [{
    		xtype : 'fieldcontainer',
    		width: 'auto',
    		layout : {
    			type : 'hbox'
    		},
    		style:{
        		'margin': '32px 32px 0px 32px !important'
        	},
    		defaults : {
    			width: 536,
    			labelAlign : 'top'
    		},
    		items : [{
                xtype: 'customcombobox',
                itemId: 'surveyTypeMainFilterCombo',
                name:'surveyTypeMainFilterCombo',
                store: Ext.create('Ext.data.Store', {
                    fields: ['code', 'value'], // Define the fields for the store
                    data: [ // Static data for the combobox
                        { code: 'AD_HOC', value: getCommonTranslation('DO_YOU_NEED_TO_SEND_AD_HOC_SURVEY') },
                        { code: 'COURSE_LEVEL', value: getCommonTranslation('DO_YOU_NEED_TO_SEND_COURSE_LEVEL_SURVEY') },
                        { code: 'PBS', value: getCommonTranslation('DO_YOU_NEED_TO_SEND_PBS_SURVEY') }
                    ]
                }),	    
                valueField:'code',
                displayField:'value',
                editable:false,
                readOnly: false,
    			fieldLabel: getCommonTranslation('SURVEY_TYPE')
            }]
    	}]
    },{
    	xtype: 'tabpanel',
    	itemId: 'option1Pnl',
    	width: '100%',
    	hidden: true,
    	plain: true,
        autoScroll: false,
        layout: 'fit',
        border: false,
        width: '100%',
        activeTab: 0,
    	items:[{
    		xtype: 'form',
    		title: getCommonTranslation('SEND_SURVEY'),
        	width: '100%',
        	plugins : "formlabelrequired",
            autoScroll: false,
        	frame: false,
        	method: 'POST',
        	standardSubmit: false,
        	itemId: 'adHocSurveySendForm',
        	style: {
        		'margin': '32px 32px 0 32px !important;'
        	},
        	items:[{
        		xtype : 'fieldcontainer',
        		width: 'auto',
        		layout : {
        			type : 'hbox'
        		},
        		defaults : {
        			width: 536,
        			labelAlign : 'top'
        		},
        		items : [{
                    xtype: 'customcombobox',
                    itemId: 'surveyListComboItemId',
                    name:'surveyListCombo',
                    store: Ext.create('Academia.store.survey.ActiveSurveyListStore'),	    
                    valueField:'sid',
                    displayField:'surveyls_title',
                    editable:false,
                    readOnly: false,
        			fieldLabel: getCommonTranslation('SURVEY_LIST'),
        			allowBlank: false,
        			matchFieldWidth:true,
        			listConfig: {
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        						picker.width = picker.up('combobox').getSize().width;
        					}
        				}
        			}
                }]
        	},{
                xtype : 'fieldcontainer',
                width: 'auto',
                layout : {
                    type : 'hbox'
                },
                defaults : {
                    width: 256,
                    labelAlign : 'top'
                },
                items : [{
                    xtype: 'textarea',
                    itemId: 'studentsCodesField',
                    name: 'studentsCodes',
                    fieldLabel: getCommonTranslation('STUDENT_CODES'),
                    allowBlank: true,
                    emptyText: getCommonTranslation('ENTER_COMMA_SEPARATED_IDS'),
                    maxLength: 15000
                },{
                    xtype: 'textarea',
                    itemId: 'employeeCodesField',
                    name: 'employeeCodes',
                    fieldLabel: getCommonTranslation('EMPLOYEE_CODES'),
                    allowBlank: true,
                    emptyText: getCommonTranslation('ENTER_COMMA_SEPARATED_IDS'),
                    maxLength: 15000
                },{
                    xtype: 'textarea',
                    itemId: 'applicantCodesField',
                    name: 'applicantCodes',
                    fieldLabel: getCommonTranslation('APPLICANT_CODES'),
                    allowBlank: true,
                    emptyText: getCommonTranslation('ENTER_COMMA_SEPARATED_IDS'),
                    maxLength: 15000
                }]
            },{
        		xtype:'fieldcontainer',
        		width: '100%',
        		items: [{
        			xtype: 'button',
        			text: getCommonTranslation('SEND_SURVEY'),
        			itemId: 'optionOneSendSurveyBtn',
        			ui: 'CustomBtnSubmit',
        			formBind:true,
        			scale: CONSTANTS.BUTTONSIZE               
        		}]	
        	}]
    	},{
    		xtype: 'panel',
    		title: getCommonTranslation('SEARCH'),
    		items:[{
    			xtype: 'form',
    			itemId: 'adHocFilterForm',
    			plugins : "formlabelrequired",
    			autoScroll: false,
    			frame: false,
    			cls:'customSearchPanel',
    			method: 'POST',
    			standardSubmit: false,
    			items: [{
    				xtype : 'fieldcontainer',
    				width: 'auto',
    				layout : {
    					type : 'hbox'
    				},
    				items : [{
    					xtype : 'radiogroup',
    					itemId : 'adHocSurveyUserTypeRadioGroupItemId',
    					width:500,
    					column:4,
    					layout: 'hbox',
    					items : [{
    						boxLabel : getCommonTranslation('STUDENT'),
    						name : 'adHocSurveyUserTypeRadio',
    						itemId : 'adHocSurveyStudentUserTypeRadioItemId',
    						inputValue: 'student',
    						checked : true
    					},{
    						boxLabel : getCommonTranslation('EMPLOYEE'),
    						name : 'adHocSurveyUserTypeRadio',
    						itemId : 'adHocSurveyEmployeeUserTypeRadioItemId',
    						inputValue: 'employee'
    					},{
    						boxLabel : getCommonTranslation('APPLICANT'),
    						name : 'adHocSurveyUserTypeRadio',
    						itemId : 'adHocSurveyApplicantUserTypeRadioItemId',
    						inputValue: 'applicant'
    					}]
    				}]
    			},{
    				xtype : 'fieldcontainer',
    				width: 'auto',
    				layout : {
    					type : 'hbox'
    				},
    				defaults : {
    					width: 536,
    					labelAlign : 'top'
    				},
    				items : [{
    					xtype: 'customcombobox',
    					name: 'surveyName',
    					itemId: 'surveyNameAdhocItemId',
    					fieldLabel:getCommonTranslation('SURVEY_NAME'),
    					store: Ext.create('Academia.store.survey.ActiveSurveyListStore'),	    
    					valueField:'sid',
    					displayField:'surveyls_title',
    					disabled:false,
    					typeAhead : true,
    					forceSelection : true,
    					allowBlank: false,
    					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    					enableKeyEvents  : 'true',
    					matchFieldWidth:true,
    					listConfig: {
    						loadingText: getCommonTranslation('SEARCHING'),
    						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    						getInnerTpl: function() {
    							return '<div class="search-item">' +
    							'{value}' +
    							'</div>';
    						},
    						listeners: {
    							beforeshow: function(picker) {
            						picker.minWidth = picker.up('combobox').getSize().width;
            						picker.width = picker.up('combobox').getSize().width;
            					}
    						}
    					}
    				}]
    			},{
    				xtype:'fieldcontainer',
    				width: '100%',
    				layout: 'hbox',
    				cls: 'customSearchPanelBtnsFieldContainerCls',
    				items: [{
    					xtype: 'button',
    					text: getCommonTranslation('SEARCH'),
    					itemId: 'searchAdhocBtn',
    					ui: 'CustomBtnSubmit',
    					formBind:true,
    					scale: CONSTANTS.BUTTONSIZE               
    				},{
    					xtype: 'button',
    					text: getCommonTranslation('RESET'),
    					itemId: 'resetAdhocBtn',
    					ui: 'CustomBtnCancel',
    					scale: CONSTANTS.BUTTONSIZE   
    				}]	
    			}]
    		},{
    			xtype: 'sendsurveyadhocgrid'
    		}]
    	}]
    },{
    	xtype: 'sendsurveycourselevelstructure',
    	itemId: 'option2Pnl',
    	hidden: true
    },{
    	xtype: 'sendsurveypbslevelstructure',
    	itemId: 'option3Pnl',
    	hidden: true
    }]
});