/**
 * @author Pritam.Patil
 * This is Average Time Search Form
 */
Ext.define('Academia.view.systemUsage.AverageTimeSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.averagetimesearchform',
    autoScroll: false,
    frame: false,
    cls:'customSearchPanel',
    items: [
    	{
    		 xtype: 'fieldcontainer',
             itemId: 'academyLocationFilter',
             layout: 'hbox',
             defaults: {
                 width: 256,
                 labelAlign: 'top'
             },
            items: [{
        	xtype:'multiselectcombofield',
            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
            width: 960,
            height:58,
            itemId : 'multiselectAcademyLocationId',
            name: 'ACADEMY_LOCATION_IDS',
            store:'common.AcademyLocationNameSeparated',
            cls:'multiBrandCampusCls',
    		valueField : 'id',
    		displayField : 'value',
    		editable:false,
    		forceSelection :true,
    		allowBlank:false,
    		maxLength:15000,
    		height:58,
    		style :{
    			  marginLeft: '0px'
    		},
    		autoloadStore: false,
    		queryMode:'local',
    		  listConfig: {
    			  listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    			  loadingText: getCommonTranslation('SEARCHING'),
                  emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                  getInnerTpl: function() {
                      return '<div class="search-item">' +
                      '{value}'  +
                      '</div>';
                  }}
             }]
        
    	},{
            xtype: 'fieldcontainer',
            itemId: 'userGroupFieldContainer',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            style:{
            //	marginLeft:'10px'
            },
            items: [{
             //   xtype: 'multiselectcombofield',
            	xtype: 'customcombobox',
                name: 'USER_GROUP_IDS',
                fieldLabel: getCommonTranslation('USER_GROUP'),
                labelAlign: 'top',
                store: 'systemusage.UserGroupStore',
                displayField: 'userGroupName',
                overridetSubmitData :true,
                valueField: 'id',
                labelAlign: 'top',
//                height: '30px',
                inputHeight: '30px',
                editable: false,
                //queryMode: 'local',
                itemId: 'frequency_user_group'
            },{
              	 xtype: 'customcombobox',
                 fieldLabel: getCommonTranslation('USER_CODE_OR_NAME'),
                 name: 'USER_IDS',
                 itemId: 'frequency_user_id',
                 //store:'coursetransaction.sectionmanagement.EmployeeIdValueSmartSearch',
                 store: 'systemusage.UserNamesAndCode',
                 valueField: 'id',
                 displayField: 'codevalue',
        		 queryParam:'codeOrName',
        		 minChars:3,
        		 typeAhead:false,
        		 triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
        		 triggerAction: '',
        			 //hideTrigger:true,
        		 forceSelection:true,
        		 //allowBlank:false,
        		 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        		 listConfig: {
        			 listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
        			loadingText: getCommonTranslation('SEARCHING'),
        			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        			getInnerTpl: function() {
        				return '<div class="search-item">' +
        				'{value}' +
        				'</div>';
        			}
        		}
            }]
        },{
        xtype: 'fieldcontainer',
        itemId: 'userTypeIndividualFieldContainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        style:{
        	//marginLeft:'10px'
        },
        items: [/*{
            xtype: 'multiselectcombofield',
            name: 'USER_IDS',
            inputHeight: '30px',
//            height: '30px',
            fieldLabel: getCommonTranslation('USER_CODE_OR_NAME'),
            store: 'systemusage.UserNamesAndCode',
            displayField: 'codevalue',
            valueField: 'id',
            labelAlign: 'top',
            width: 536,
            editable: false,
            //overridetSubmitData :true,
            queryMode: 'local',
            maxLength:15000,
           // maxWidth : 210,
            itemId: 'frequency_user_id',
            //emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
            	listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo) {
                        combo.getStore().on("load", function(store, items) {
                        	if (items.length == 0){
                            	if(Ext.select('.x-boundlist-item').elements.length>0){
                            		Ext.select('.x-boundlist-item').elements[0].hidden = true;	
                            	}
                            }
                            else{
                            	if(Ext.select('.x-boundlist-item').elements.length>0){
                            		Ext.select('.x-boundlist-item').elements[0].hidden = false;	
                            	}
                            }
                        });
                    }        
				}}
        }*//*, {
            xtype: 'multiselectcombofield',
            name: 'USER_NAMES',
            fieldLabel: getCommonTranslation('USER_NAME'),
            store: 'systemusage.UsersNameStore',
            displayField: 'value',
            //autoloadStore: false,
            //overridetSubmitData :true,
//            height: '30px',
            inputHeight: '30px',
            valueField: 'id',
            //editable: false,
            queryMode: 'local',
            itemId: 'frequency_user_name',
            maxLength:15000,
            maxWidth : 210,
            //emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
            	listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
            	loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                    '{code} / {value}'  +
                    '</div>';
                }}
        }*/]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('FROM_DATE'),
            name: 'FROM_DATE',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            itemId: 'fromDate',
            vtype: 'daterange',
            endDateField: 'toDate'
        }, {
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('TO_DATE'),
            name: 'TO_DATE',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            itemId: 'toDate',
            vtype: 'daterange',
            startDateField: 'fromDate'
        }]}, {
        xtype: 'fieldcontainer',
        width: '100%',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'averageTimeSearchBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind : true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CLEAR_SEARCH'),
            itemId: 'averageTimeClearSearchBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
            //formBind : true
        }]
    }]
});