/**
 *  @author sumit.meena
 */
Ext.define('Academia.view.transport.route.RouteMasterGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.routemastergrid',
	store : 'transport.route.RouteMasterStore',
	title: getTransportTranslation('ROUTE_LIST'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.route.RouteMasterStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getTransportTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getTransportTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getTransportTranslation('ROUTE'),
		dataIndex : 'routeName',
		flex:1
	},{
		header : getTransportTranslation('RESPONSIBLE_PERSON'),
		dataIndex : 'responsiblePersonNameNew',
		flex:1
		/*renderer:function(value,rec){
			if(value){
				return value;
			}else{
				return rec.record.data.responsiblePersonNameExt;
			}
		}*/
	},{
		header : getTransportTranslation('START_LOCATION'),
		dataIndex : 'wsStartLocationNew',
		flex:1
		/*renderer:function(value){
			if(value){
				return value.locationName;
			}
		}*/
	},{
		header : getTransportTranslation('END_LOCATION'),
		dataIndex : 'wsEndLocationNew',
		flex:1
		/*renderer:function(value){
			if(value){
				return value.locationName;
			}
		}*/
	},{
		header : getTransportTranslation('ROUND_TRIP'),
		dataIndex : 'whetherRoundTrip',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)) {
				if(value==true){
					return getTransportTranslation('YES');
				}else{
					return getTransportTranslation('NO');
				}
			}
		}
	},{
		header : getTransportTranslation('DISTANCE'),
		dataIndex : 'distance',
		flex:1
	},{
		header : getTransportTranslation('NO_OF_STOPS'),
		dataIndex : 'noOfStops',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)&& value>0) {
				return "<a href='#'>"+value+"</a>";
			}else{
				return 0;
			}
		}
	/*},{
		header : getTransportTranslation('NO_OF_SERVICES'),
		dataIndex : 'noOfServices',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)&& value>0) {
				return "<a href='#'>"+value+"</a>";
			}else{
				return 0;
			}
		}
	},{
		header : getTransportTranslation('NO_OF_VEHICLES'),
		dataIndex : 'noOfVehicles',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)&& value>0) {
				return "<a href='#'>"+value+"</a>";
			}else{
				return 0;
			}
		}
	},{
		header : getTransportTranslation('NO_OF_USERS_COVERED'),
		dataIndex : 'noOfUserCoverd',
		flex:1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)&& value>0) {
				return "<a href='#'>"+value+"</a>";
			}else{
				return 0;
			}
		}*/
	}]
});